/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.saxon;

import com.helger.annotation.misc.DevelopersNote;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SaxonNamespaceContext
implements NamespaceContext,
NamespaceResolver {
    private final MapBasedNamespaceContext m_aCtx;

    public SaxonNamespaceContext(@NonNull MapBasedNamespaceContext mapBasedNamespaceContext) {
        this.m_aCtx = (MapBasedNamespaceContext)ValueEnforcer.notNull((Object)mapBasedNamespaceContext, (String)"Ctx");
    }

    public @Nullable NamespaceUri getURIForPrefix(@Nullable String string, boolean bl) {
        if (bl && StringHelper.isEmpty((String)string)) {
            return NamespaceUri.of((String)this.m_aCtx.getDefaultNamespaceURI());
        }
        return NamespaceUri.of((String)this.m_aCtx.getCustomNamespaceURI(string));
    }

    public @NonNull Iterator<String> iteratePrefixes() {
        CommonsArrayList commonsArrayList = new CommonsArrayList((Collection)this.m_aCtx.getPrefixToNamespaceURIMap().keySet());
        commonsArrayList.add((Object)"");
        return commonsArrayList.iterator();
    }

    @Override
    public @NonNull String getNamespaceURI(@NonNull String string) {
        return this.m_aCtx.getNamespaceURI(string);
    }

    @Override
    public @Nullable String getPrefix(@NonNull String string) {
        return this.m_aCtx.getPrefix(string);
    }

    @Override
    @DevelopersNote(value="Java 8: Iterator; Java 10: Iterator<String>")
    public @NonNull Iterator<String> getPrefixes(@NonNull String string) {
        return this.m_aCtx.getPrefixes(string);
    }
}

