/*
 * Decompiled with CFR 0.152.
 */
package com.helger.rdc.servlet;

import com.helger.photon.api.IAPIRegistry;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.audit.DoNothingAuditor;
import com.helger.photon.audit.IAuditor;
import com.helger.photon.core.servlet.WebAppListener;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.rdc.api.RdcConfig;
import com.helger.rdc.api.me.incoming.IMEIncomingHandler;
import com.helger.rdc.core.RdcInit;
import com.helger.rdc.mockdp.MockDO;
import com.helger.rdc.webapi.RdcApiInit;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;

public class RdcWebAppListener
extends WebAppListener {
    public RdcWebAppListener() {
        this.setHandleStatisticsOnEnd(false);
    }

    protected String getDataPath(@Nonnull ServletContext servletContext) {
        String string = RdcConfig.WebApp.getDataPath();
        if (string == null) {
            string = super.getDataPath(servletContext);
        }
        return string;
    }

    protected String getServletContextPath(ServletContext servletContext) {
        try {
            return super.getServletContextPath(servletContext);
        }
        catch (IllegalStateException illegalStateException) {
            return this.getDataPath(servletContext);
        }
    }

    protected void afterContextInitialized(ServletContext servletContext) {
        RdcInit.initGlobally((ServletContext)servletContext, (IMEIncomingHandler)new MockDO());
        AuditHelper.setAuditor((IAuditor)new DoNothingAuditor((ICurrentUserIDProvider)LoggedInUserManager.getInstance()));
    }

    protected void initAPI(@Nonnull IAPIRegistry iAPIRegistry) {
        RdcApiInit.initAPI((IAPIRegistry)iAPIRegistry);
    }

    protected void beforeContextDestroyed(ServletContext servletContext) {
        RdcInit.shutdownGlobally((ServletContext)servletContext);
    }
}

