/*
 * Decompiled with CFR 0.152.
 */
package com.helger.rdc.mockdp;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.concurrent.ThreadHelper;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.state.ESuccess;
import com.helger.json.IJsonObject;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.rdc.api.RdcConfig;
import com.helger.rdc.api.me.EMEProtocol;
import com.helger.rdc.api.me.incoming.IMEIncomingHandler;
import com.helger.rdc.api.me.incoming.MEIncomingException;
import com.helger.rdc.api.me.model.MEMessage;
import com.helger.rdc.api.me.model.MEPayload;
import com.helger.rdc.api.rest.RDCPayload;
import com.helger.rdc.webapi.as4.ApiPostLookendAndSend;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import eu.de4a.iem.jaxb.common.idtypes.LegalPersonIdentifierType;
import eu.de4a.iem.jaxb.common.types.CanonicalEvidenceType;
import eu.de4a.iem.jaxb.common.types.ErrorListType;
import eu.de4a.iem.jaxb.common.types.ErrorType;
import eu.de4a.iem.jaxb.common.types.RequestTransferEvidenceUSIIMDRType;
import eu.de4a.iem.jaxb.common.types.ResponseTransferEvidenceType;
import eu.de4a.iem.jaxb.t42.v0_6.ActivityType;
import eu.de4a.iem.jaxb.t42.v0_6.AddressType;
import eu.de4a.iem.jaxb.t42.v0_6.LegalEntityType;
import eu.de4a.iem.jaxb.t42.v0_6.NamesType;
import eu.de4a.iem.jaxb.w3.cv11.bc.LegalEntityLegalNameType;
import eu.de4a.iem.xml.de4a.DE4AMarshaller;
import eu.de4a.iem.xml.de4a.DE4AResponseDocumentHelper;
import eu.de4a.iem.xml.de4a.EDE4ACanonicalEvidenceType;
import eu.de4a.iem.xml.de4a.IDE4ACanonicalEvidenceType;
import eu.de4a.iem.xml.de4a.t42.v0_6.DE4AT42Marshaller;
import eu.de4a.kafkaclient.DE4AKafkaClient;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MockDO
implements IMEIncomingHandler {
    public static final AtomicBoolean DO_ACTIVE = new AtomicBoolean(true);
    private static final Logger LOGGER = LoggerFactory.getLogger(MockDO.class);

    @Nonnull
    private static ESuccess _handleDBARequest(@Nonnull MEMessage mEMessage, @Nonnull Document document) {
        ErrorListType errorListType;
        LOGGER.info("Handling as DBA request");
        RequestTransferEvidenceUSIIMDRType requestTransferEvidenceUSIIMDRType = (RequestTransferEvidenceUSIIMDRType)DE4AMarshaller.drImRequestMarshaller().read((Node)document);
        if (requestTransferEvidenceUSIIMDRType == null) {
            DE4AKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"Passed request ist not a valid IM request");
            return ESuccess.FAILURE;
        }
        LegalPersonIdentifierType legalPersonIdentifierType = requestTransferEvidenceUSIIMDRType.getDataRequestSubject().getDataSubjectCompany();
        if (legalPersonIdentifierType == null) {
            DE4AKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"No DRS company found");
            return ESuccess.FAILURE;
        }
        if (!"urn:de4a-eu:CanonicalEvidenceType::CompanyRegistration".equals(requestTransferEvidenceUSIIMDRType.getCanonicalEvidenceTypeId())) {
            DE4AKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)("The CanonicalEvidenceType '" + requestTransferEvidenceUSIIMDRType.getCanonicalEvidenceTypeId() + "' is not supported"));
            return ESuccess.FAILURE;
        }
        ResponseTransferEvidenceType responseTransferEvidenceType = DE4AResponseDocumentHelper.createResponseTransferEvidence((RequestTransferEvidenceUSIIMDRType)requestTransferEvidenceUSIIMDRType);
        if (!DO_ACTIVE.get()) {
            DE4AKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"We cannot reach our DO - oooooohhhhh :(");
            errorListType = new ErrorListType();
            ErrorType errorType = new ErrorType();
            errorType.setCode("67890");
            errorType.setText("Our DO is not reachable - please try again later");
            errorListType.addError(errorType);
            responseTransferEvidenceType.setErrorList(errorListType);
        } else if (!"AT/NL/???".equals(legalPersonIdentifierType.getLegalPersonIdentifier())) {
            DE4AKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)("The DRS company identifier '" + legalPersonIdentifierType.getLegalPersonIdentifier() + "' is not supported"));
            errorListType = new ErrorListType();
            ErrorType errorType = new ErrorType();
            errorType.setCode("12345");
            errorType.setText("The eIDAS identifier '" + legalPersonIdentifierType.getLegalPersonIdentifier() + "' is unknown");
            errorListType.addError(errorType);
            responseTransferEvidenceType.setErrorList(errorListType);
        } else {
            DE4AKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)("The DRS company identifier '" + legalPersonIdentifierType.getLegalPersonIdentifier() + "' was found - building result"));
            errorListType = new CanonicalEvidenceType();
            LegalEntityType legalEntityType = new LegalEntityType();
            NamesType namesType = new NamesType();
            LegalEntityLegalNameType legalEntityLegalNameType = new LegalEntityLegalNameType();
            legalEntityLegalNameType.setValue("Bla Blub GmbH");
            namesType.setLegalEntityLegalName(legalEntityLegalNameType);
            legalEntityType.addCompanyName(namesType);
            legalEntityType.setCompanyType("GmbH");
            legalEntityType.setCompanyStatus("active");
            namesType = new ActivityType();
            namesType.addNaceCode("1234");
            legalEntityType.setCompanyActivity((ActivityType)namesType);
            legalEntityType.setRegistrationDate(PDTFactory.getCurrentLocalDate().minusDays(1000L));
            legalEntityType.setCompanyEUID("AT98765");
            namesType = new AddressType();
            namesType.setThoroughfare("Wien");
            namesType.setPostCode("1010");
            namesType.setPoBox("543");
            namesType.setAdminUnitL1("Austria");
            legalEntityType.addRegisteredAddress((AddressType)namesType);
            errorListType.setAny((Object)DE4AT42Marshaller.legalEntity().getAsDocument((Object)legalEntityType).getDocumentElement());
            responseTransferEvidenceType.setCanonicalEvidence((CanonicalEvidenceType)errorListType);
        }
        errorListType = DE4AMarshaller.drImResponseMarshaller((IDE4ACanonicalEvidenceType)EDE4ACanonicalEvidenceType.T42_COMPANY_INFO_V06);
        LOGGER.info("Message to be send back:\n" + errorListType.setFormattedOutput(true).getAsString((Object)responseTransferEvidenceType));
        MockDO._waitAndRunAsync(mEMessage, errorListType.getAsBytes((Object)responseTransferEvidenceType));
        return ESuccess.SUCCESS;
    }

    private static void _waitAndRunAsync(@Nonnull MEMessage mEMessage, @Nonnull byte[] byArray) {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        executorService.submit(() -> {
            ThreadHelper.sleep((long)1000L);
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            RDCPayload rDCPayload = new RDCPayload();
            rDCPayload.setValue(byArray);
            rDCPayload.setMimeType(CMimeType.APPLICATION_XML.getAsString());
            rDCPayload.setContentID("ResponseTransferEvidence");
            commonsArrayList.add((Object)rDCPayload);
            IJsonObject iJsonObject = ApiPostLookendAndSend.perform((IParticipantIdentifier)mEMessage.getReceiverID(), (IParticipantIdentifier)mEMessage.getSenderID(), (IDocumentTypeIdentifier)mEMessage.getDocumentTypeID(), (IProcessIdentifier)RdcConfig.getIdentifierFactory().createProcessIdentifier("urn:de4a-eu:MessageType", "response"), (String)EMEProtocol.AS4.getTransportProfileID(), (Iterable)commonsArrayList);
            LOGGER.info("Sending result:\n" + iJsonObject.getAsJsonString(JsonWriterSettings.DEFAULT_SETTINGS_FORMATTED));
        });
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)executorService);
    }

    private static void _handleXML(@Nonnull MEMessage mEMessage, @Nullable String string, @Nullable String string2, @Nonnull Document document) {
        boolean bl = false;
        if ("RequestTransferEvidence".equals(string2) && "http://www.de4a.eu/2020/data/requestor/pattern/intermediate".equals(string)) {
            if (MockDO._handleDBARequest(mEMessage, document).isSuccess()) {
                bl = true;
            }
        } else if (!"ResponseTransferEvidence".equals(string2) || "http://www.de4a.eu/2020/data/requestor/pattern/intermediate".equals(string)) {
            // empty if block
        }
        if (!bl) {
            LOGGER.info("Received unhandled XML:\n" + XMLWriter.getNodeAsString((Node)document, (IXMLWriterSettings)new XMLWriterSettings().setIndent(EXMLSerializeIndent.INDENT_AND_ALIGN)));
        }
    }

    static void handleIncomingRequest(@Nonnull MEMessage mEMessage, @Nonnull ByteArrayWrapper byteArrayWrapper) {
        LOGGER.info("Now trying to read the message as XML");
        Document document = DOMReader.readXMLDOM((byte[])byteArrayWrapper.bytes(), (int)byteArrayWrapper.getOffset(), (int)byteArrayWrapper.size());
        if (document == null) {
            DE4AKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)("Failed to read content as XML. Content as UTF-8:\n" + new String(byteArrayWrapper.bytes(), byteArrayWrapper.getOffset(), byteArrayWrapper.size(), StandardCharsets.UTF_8)));
        } else {
            String string = document.getDocumentElement().getNamespaceURI();
            String string2 = document.getDocumentElement().getLocalName();
            LOGGER.info("Received a document with declaration '{" + string + "}" + string2 + "'");
            MockDO._handleXML(mEMessage, string, string2, document);
        }
    }

    public void handleIncomingRequest(@Nonnull MEMessage mEMessage) throws MEIncomingException {
        if (mEMessage.payloads().size() >= 2) {
            ByteArrayWrapper byteArrayWrapper = ((MEPayload)mEMessage.payloads().get(1)).getData();
            MockDO.handleIncomingRequest(mEMessage, byteArrayWrapper);
        } else {
            DE4AKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"Incoming message seems to be ill-formatted - too few payloads. Trying first one.");
            ByteArrayWrapper byteArrayWrapper = ((MEPayload)mEMessage.payloads().get(0)).getData();
            MockDO.handleIncomingRequest(mEMessage, byteArrayWrapper);
        }
    }
}

