/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jquery;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.id.IHasID;
import com.helger.html.EHTMLElement;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.jquery.IJQuerySelector;
import com.helger.html.jquery.JQueryInvocation;
import com.helger.html.jquery.JQueryProperty;
import com.helger.html.jquery.JQuerySelector;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFieldRef;
import com.helger.html.jscode.JSFunction;
import com.helger.html.jscode.html.JSHtml;
import com.helger.json.IJson;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.XMLWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Node;

@Immutable
@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"})
public final class JQuery {
    private static final AtomicBoolean USE_DOLLAR = new AtomicBoolean(true);
    private static final JQuery INSTANCE = new JQuery();

    private JQuery() {
    }

    public static void setUseDollarForJQuery(boolean bl) {
        USE_DOLLAR.set(bl);
    }

    public static boolean isUseDollarForJQuery() {
        return USE_DOLLAR.get();
    }

    @Nonnull
    public static JSFunction jQueryFunction() {
        return new JSFunction(JQuery.isUseDollarForJQuery() ? "$" : "jQuery");
    }

    @Nonnull
    public static JQueryInvocation jQuery(@Nonnull IJSExpression iJSExpression) {
        return (JQueryInvocation)new JQueryInvocation(JQuery.jQueryFunction()).arg(iJSExpression);
    }

    @Nonnull
    public static JQueryInvocation jQuery(@Nonnull String string) {
        return JQuery.jQuery((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public static JQueryInvocation jQuery(@Nonnull IHCNode iHCNode) {
        return JQuery.jQuery(HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode));
    }

    @Nonnull
    public static JQueryInvocation jQueryDocument() {
        return JQuery.jQuery((IJSExpression)JSHtml.document());
    }

    @Nonnull
    public static JQueryInvocation jQueryWindow() {
        return JQuery.jQuery((IJSExpression)JSHtml.window());
    }

    @Nonnull
    public static JQueryInvocation jQueryThis() {
        return JQuery.jQuery(JSExpr.THIS);
    }

    @Nonnull
    public static JQueryInvocation ajax(@Nonnull JSAssocArray jSAssocArray) {
        return (JQueryInvocation)JQuery.ajax().arg((IJSExpression)jSAssocArray);
    }

    @Nonnull
    public static JQueryInvocation globalEval(@Nonnull String string) {
        return (JQueryInvocation)JQuery.globalEval().arg(string);
    }

    @Nonnull
    public static JQueryInvocation globalEval(@Nonnull IJSExpression iJSExpression) {
        return (JQueryInvocation)JQuery.globalEval().arg(iJSExpression);
    }

    @Nonnull
    public static JQueryInvocation parseHTML(@Nonnull Node node) {
        return JQuery.parseHTML(XMLWriter.getNodeAsString((Node)node));
    }

    @Nonnull
    public static JQueryInvocation parseHTML(@Nonnull IMicroNode iMicroNode) {
        return JQuery.parseHTML(MicroWriter.getNodeAsString((IMicroNode)iMicroNode));
    }

    @Nonnull
    public static JQueryInvocation parseHTML(@Nonnull IHCNode iHCNode) {
        return JQuery.parseHTML(HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode));
    }

    @Nonnull
    public static JQueryInvocation parseHTML(@Nonnull String string) {
        return JQuery.parseHTML((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public static JQueryInvocation parseHTML(@Nonnull IJSExpression iJSExpression) {
        return (JQueryInvocation)JQuery.parseHTML().arg(iJSExpression);
    }

    @Nonnull
    public static JQueryInvocation parseJSON(@Nonnull IJson iJson) {
        return JQuery.parseJSON(iJson.getAsJsonString());
    }

    @Nonnull
    public static JQueryInvocation parseJSON(@Nonnull String string) {
        return JQuery.parseJSON((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public static JQueryInvocation parseJSON(@Nonnull IJSExpression iJSExpression) {
        return (JQueryInvocation)JQuery.parseJSON().arg(iJSExpression);
    }

    @Nonnull
    public static JQueryInvocation parseXML(@Nonnull Node node) {
        return JQuery.parseXML(XMLWriter.getNodeAsString((Node)node));
    }

    @Nonnull
    public static JQueryInvocation parseXML(@Nonnull IMicroNode iMicroNode) {
        return JQuery.parseXML(MicroWriter.getNodeAsString((IMicroNode)iMicroNode));
    }

    @Nonnull
    public static JQueryInvocation parseXML(@Nonnull String string) {
        return JQuery.parseXML((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public static JQueryInvocation parseXML(@Nonnull IJSExpression iJSExpression) {
        return (JQueryInvocation)JQuery.parseXML().arg(iJSExpression);
    }

    @Nonnull
    public static JQueryInvocation idRef(@Nonnull @Nonempty String string) {
        return JQuerySelector.id(string).invoke();
    }

    @Nonnull
    public static JQueryInvocation idRef(@Nonnull IJSExpression iJSExpression) {
        return JQuerySelector.id(iJSExpression).invoke();
    }

    @Nonnull
    public static JQueryInvocation idRef(@Nonnull @Nonempty IHasID<String> iHasID) {
        return JQuerySelector.id(iHasID).invoke();
    }

    @Nonnull
    public static JQueryInvocation idRef(@Nonnull @Nonempty IHCHasID<?> iHCHasID) {
        return JQuerySelector.id(iHCHasID).invoke();
    }

    @Nonnull
    public static JQueryInvocation idRefMultiple(String ... stringArray) {
        ValueEnforcer.notEmpty((Object[])stringArray, (String)"IDs");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (String string : stringArray) {
            commonsArrayList.add((Object)JQuerySelector.id(string));
        }
        return JQuerySelector.multiple((List<IJQuerySelector>)commonsArrayList).invoke();
    }

    @Nonnull
    @SafeVarargs
    public static JQueryInvocation idRefMultiple(IHasID<String> ... iHasIDArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iHasIDArray, (String)"IDs");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IHasID<String> iHasID : iHasIDArray) {
            commonsArrayList.add((Object)JQuerySelector.id(iHasID));
        }
        return JQuerySelector.multiple((List<IJQuerySelector>)commonsArrayList).invoke();
    }

    @Nonnull
    public static JQueryInvocation idRefMultiple(IJSExpression ... iJSExpressionArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iJSExpressionArray, (String)"IDs");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IJSExpression iJSExpression : iJSExpressionArray) {
            commonsArrayList.add((Object)JQuerySelector.id(iJSExpression));
        }
        return JQuerySelector.multiple((List<IJQuerySelector>)commonsArrayList).invoke();
    }

    @Nonnull
    public static JQueryInvocation idRefMultiple(IHCHasID<?> ... iHCHasIDArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iHCHasIDArray, (String)"IDs");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IHCHasID<?> iHCHasID : iHCHasIDArray) {
            commonsArrayList.add((Object)JQuerySelector.id(iHCHasID));
        }
        return JQuerySelector.multiple((List<IJQuerySelector>)commonsArrayList).invoke();
    }

    @Nonnull
    public static JQueryInvocation idRefMultiple(@Nonnull @Nonempty Iterable<String> iterable) {
        ValueEnforcer.notEmpty(iterable, (String)"IDs");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (String string : iterable) {
            commonsArrayList.add((Object)JQuerySelector.id(string));
        }
        return JQuerySelector.multiple((List<IJQuerySelector>)commonsArrayList).invoke();
    }

    @Nonnull
    public static JQueryInvocation classRef(@Nonnull ICSSClassProvider iCSSClassProvider) {
        return JQuerySelector.clazz(iCSSClassProvider).invoke();
    }

    @Nonnull
    public static JQueryInvocation classRefMultiple(ICSSClassProvider ... iCSSClassProviderArray) {
        ValueEnforcer.notEmpty((Object[])iCSSClassProviderArray, (String)"CSSClasses");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (ICSSClassProvider iCSSClassProvider : iCSSClassProviderArray) {
            commonsArrayList.add((Object)JQuerySelector.clazz(iCSSClassProvider));
        }
        return JQuerySelector.multiple((List<IJQuerySelector>)commonsArrayList).invoke();
    }

    @Nonnull
    public static JQueryInvocation classRefMultiple(@Nonnull @Nonempty Iterable<? extends ICSSClassProvider> iterable) {
        ValueEnforcer.notEmpty(iterable, (String)"CSSClasses");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (ICSSClassProvider iCSSClassProvider : iterable) {
            commonsArrayList.add((Object)JQuerySelector.clazz(iCSSClassProvider));
        }
        return JQuerySelector.multiple((List<IJQuerySelector>)commonsArrayList).invoke();
    }

    @Nonnull
    public static JQueryInvocation elementNameRef(@Nonnull EHTMLElement eHTMLElement) {
        return JQuerySelector.element(eHTMLElement).invoke();
    }

    @Nonnull
    public static JQueryInvocation elementNameRef(@Nonnull @Nonempty String string) {
        return JQuerySelector.element(string).invoke();
    }

    @Nonnull
    public static JQueryInvocation elementNameRef(@Nonnull EHTMLElement eHTMLElement, @Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.element(eHTMLElement).chain(iJQuerySelector).invoke();
    }

    @Nonnull
    public static JQueryInvocation elementNameRef(@Nonnull @Nonempty String string, @Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.element(string).chain(iJQuerySelector).invoke();
    }

    @Nonnull
    public static JQueryInvocation elementNameWithIDRef(@Nonnull EHTMLElement eHTMLElement, @Nonnull @Nonempty String string) {
        return JQuery.elementNameRef(eHTMLElement, JQuerySelector.id(string));
    }

    @Nonnull
    public static JQueryInvocation elementNameWithIDRef(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return JQuery.elementNameRef(string, JQuerySelector.id(string2));
    }

    @Nonnull
    public static JQueryInvocation elementNameWithClassRef(@Nonnull EHTMLElement eHTMLElement, @Nonnull ICSSClassProvider iCSSClassProvider) {
        return JQuery.elementNameRef(eHTMLElement, JQuerySelector.clazz(iCSSClassProvider));
    }

    @Nonnull
    public static JQueryInvocation elementNameWithClassRef(@Nonnull @Nonempty String string, @Nonnull ICSSClassProvider iCSSClassProvider) {
        return JQuery.elementNameRef(string, JQuerySelector.clazz(iCSSClassProvider));
    }

    @Nonnull
    public static JQueryInvocation nameAttrRef(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"NameAttrValue");
        return JQuerySelector.nameAttr(string).invoke();
    }

    @Nonnull
    public static OnDocumentReadyInvocation onDocumentReady() {
        JSAnonymousFunction jSAnonymousFunction = new JSAnonymousFunction();
        JQueryInvocation jQueryInvocation = (JQueryInvocation)JQuery.jQueryDocument().ready(jSAnonymousFunction);
        return new OnDocumentReadyInvocation(jQueryInvocation, jSAnonymousFunction);
    }

    @Nonnull
    public static JQueryInvocation onDocumentReady(@Nonnull IHasJSCode iHasJSCode) {
        JSAnonymousFunction jSAnonymousFunction = new JSAnonymousFunction();
        jSAnonymousFunction.body().add(iHasJSCode);
        return (JQueryInvocation)JQuery.jQueryDocument().ready(jSAnonymousFunction);
    }

    @Nonnull
    public static JQueryInvocation Callbacks() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "Callbacks");
    }

    @Nonnull
    public static JQueryInvocation Deferred() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "Deferred");
    }

    @Nonnull
    public static JQueryInvocation ajax() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "ajax");
    }

    @Nonnull
    public static JQueryInvocation ajaxPrefilter() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "ajaxPrefilter");
    }

    @Nonnull
    public static JQueryInvocation ajaxSetup() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "ajaxSetup");
    }

    @Nonnull
    public static JQueryInvocation ajaxTransport() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "ajaxTransport");
    }

    @Nonnull
    public static JQueryInvocation contains() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "contains");
    }

    @Nonnull
    public static JQueryInvocation data() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "data");
    }

    @Nonnull
    public static JQueryInvocation dequeue() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "dequeue");
    }

    @Nonnull
    public static JQueryInvocation each() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "each");
    }

    @Nonnull
    public static JQueryInvocation error() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "error");
    }

    @Nonnull
    public static JQueryInvocation extend() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "extend");
    }

    @Nonnull
    public static JSFieldRef fn() {
        return JQueryProperty.jQueryField().ref("fn");
    }

    @Nonnull
    public static JQueryInvocation fn_extend() {
        return new JQueryInvocation((IJSExpression)JQuery.fn(), "extend");
    }

    @Nonnull
    public static JQueryInvocation get() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "get");
    }

    @Nonnull
    public static JQueryInvocation getJSON() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "getJSON");
    }

    @Nonnull
    public static JQueryInvocation getScript() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "getScript");
    }

    @Nonnull
    public static JQueryInvocation globalEval() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "globalEval");
    }

    @Nonnull
    public static JQueryInvocation grep() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "grep");
    }

    @Nonnull
    public static JQueryInvocation hasData() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "hasData");
    }

    @Nonnull
    public static JQueryInvocation holdReady() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "holdReady");
    }

    @Nonnull
    public static JQueryInvocation inArray() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "inArray");
    }

    @Nonnull
    public static JQueryInvocation isArray() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "isArray");
    }

    @Nonnull
    public static JQueryInvocation isEmptyObject() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "isEmptyObject");
    }

    @Nonnull
    public static JQueryInvocation isFunction() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "isFunction");
    }

    @Nonnull
    public static JQueryInvocation isNumeric() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "isNumeric");
    }

    @Nonnull
    public static JQueryInvocation isPlainObject() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "isPlainObject");
    }

    @Nonnull
    public static JQueryInvocation isWindow() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "isWindow");
    }

    @Nonnull
    public static JQueryInvocation isXMLDoc() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "isXMLDoc");
    }

    @Nonnull
    public static JQueryInvocation makeArray() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "makeArray");
    }

    @Nonnull
    public static JQueryInvocation map() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "map");
    }

    @Nonnull
    public static JQueryInvocation merge() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "merge");
    }

    @Nonnull
    public static JQueryInvocation noConflict() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "noConflict");
    }

    @Nonnull
    public static JQueryInvocation noop() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "noop");
    }

    @Nonnull
    public static JQueryInvocation now() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "now");
    }

    @Nonnull
    public static JQueryInvocation param() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "param");
    }

    @Nonnull
    public static JQueryInvocation parseHTML() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "parseHTML");
    }

    @Nonnull
    public static JQueryInvocation parseJSON() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "parseJSON");
    }

    @Nonnull
    public static JQueryInvocation parseXML() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "parseXML");
    }

    @Nonnull
    public static JQueryInvocation post() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "post");
    }

    @Nonnull
    public static JQueryInvocation proxy() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "proxy");
    }

    @Nonnull
    public static JQueryInvocation queue() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "queue");
    }

    @Nonnull
    public static JQueryInvocation removeData() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "removeData");
    }

    @Nonnull
    public static JQueryInvocation trim() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "trim");
    }

    @Nonnull
    public static JQueryInvocation type() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "type");
    }

    @Nonnull
    public static JQueryInvocation unique() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "unique");
    }

    @Nonnull
    public static JQueryInvocation when() {
        return new JQueryInvocation((IJSExpression)JQueryProperty.jQueryField(), "when");
    }

    public static class OnDocumentReadyInvocation {
        private final JQueryInvocation m_aInvocation;
        private final JSAnonymousFunction m_aAnonFunction;

        public OnDocumentReadyInvocation(@Nonnull JQueryInvocation jQueryInvocation, @Nonnull JSAnonymousFunction jSAnonymousFunction) {
            this.m_aInvocation = jQueryInvocation;
            this.m_aAnonFunction = jSAnonymousFunction;
        }

        public JQueryInvocation getInvocation() {
            return this.m_aInvocation;
        }

        public JSAnonymousFunction getAnonFunction() {
            return this.m_aAnonFunction;
        }
    }
}

