/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.sax.LoggingSAXErrorHandler;
import com.helger.xml.serialize.read.XMLLoggingExceptionCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.validation.Schema;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

@ThreadSafe
public final class DOMReaderDefaultSettings {
    public static final boolean DEFAULT_REQUIRES_NEW_XML_PARSER_EXPLICITLY = false;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultNamespaceAware = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultValidating = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultIgnoringElementContentWhitespace = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultExpandEntityReferences = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultIgnoringComments = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultCoalescing = true;
    @GuardedBy(value="s_aRWLock")
    private static Schema s_aDefaultSchema;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultXIncludeAware;
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<EXMLParserProperty, Object> s_aDefaultProperties;
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<EXMLParserFeature, Boolean> s_aDefaultFeatures;
    @GuardedBy(value="s_aRWLock")
    private static EntityResolver s_aDefaultEntityResolver;
    @GuardedBy(value="s_aRWLock")
    private static ErrorHandler s_aDefaultErrorHandler;
    private static CallbackList<IExceptionCallback<Throwable>> s_aDefaultExceptionCallbacks;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultRequiresNewXMLParserExplicitly;
    private static final DOMReaderDefaultSettings s_aInstance;

    private DOMReaderDefaultSettings() {
    }

    public static boolean isNamespaceAware() {
        return s_aRWLock.readLocked(() -> s_bDefaultNamespaceAware);
    }

    public static void setNamespaceAware(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultNamespaceAware = bl;
            return s_bDefaultNamespaceAware;
        });
    }

    public static boolean isValidating() {
        return s_aRWLock.readLocked(() -> s_bDefaultValidating);
    }

    public static void setValidating(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultValidating = bl;
            return s_bDefaultValidating;
        });
    }

    public static boolean isIgnoringElementContentWhitespace() {
        return s_aRWLock.readLocked(() -> s_bDefaultIgnoringElementContentWhitespace);
    }

    public static void setIgnoringElementContentWhitespace(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultIgnoringElementContentWhitespace = bl;
            return s_bDefaultIgnoringElementContentWhitespace;
        });
    }

    public static boolean isExpandEntityReferences() {
        return s_aRWLock.readLocked(() -> s_bDefaultExpandEntityReferences);
    }

    public static void setExpandEntityReferences(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultExpandEntityReferences = bl;
            return s_bDefaultExpandEntityReferences;
        });
    }

    public static boolean isIgnoringComments() {
        return s_aRWLock.readLocked(() -> s_bDefaultIgnoringComments);
    }

    public static void setIgnoringComments(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultIgnoringComments = bl;
            return s_bDefaultIgnoringComments;
        });
    }

    public static boolean isCoalescing() {
        return s_aRWLock.readLocked(() -> s_bDefaultCoalescing);
    }

    public static void setCoalescing(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultCoalescing = bl;
            return s_bDefaultCoalescing;
        });
    }

    @Nullable
    public static Schema getSchema() {
        return (Schema)s_aRWLock.readLocked(() -> s_aDefaultSchema);
    }

    public static void setSchema(@Nullable Schema schema) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultSchema = schema;
            return s_aDefaultSchema;
        });
    }

    public static boolean isXIncludeAware() {
        return s_aRWLock.readLocked(() -> s_bDefaultXIncludeAware);
    }

    public static void setXIncludeAware(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultXIncludeAware = bl;
            return s_bDefaultXIncludeAware;
        });
    }

    public static boolean hasAnyProperties() {
        return s_aRWLock.readLocked(() -> s_aDefaultProperties.isNotEmpty());
    }

    @Nullable
    public static Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return null;
        }
        return s_aRWLock.readLocked(() -> s_aDefaultProperties.get((Object)eXMLParserProperty));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserProperty, Object> getAllPropertyValues() {
        return (ICommonsMap)s_aRWLock.readLocked(() -> s_aDefaultProperties.getClone());
    }

    public static void setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserProperty), (String)"Property");
        s_aRWLock.writeLocked(() -> {
            if (object != null) {
                s_aDefaultProperties.put((Object)eXMLParserProperty, object);
            } else {
                s_aDefaultProperties.remove((Object)eXMLParserProperty);
            }
        });
    }

    public static void setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null) {
            s_aRWLock.writeLocked(() -> s_aDefaultProperties.putAll(map));
        }
    }

    @Nonnull
    public static EChange removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)s_aRWLock.writeLocked(() -> s_aDefaultProperties.removeObject((Object)eXMLParserProperty));
    }

    @Nonnull
    public static EChange removeAllPropertyValues() {
        return (EChange)s_aRWLock.writeLocked(() -> s_aDefaultProperties.removeAll());
    }

    public static boolean hasAnyFeature() {
        return s_aRWLock.readLocked(() -> s_aDefaultFeatures.isNotEmpty());
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return null;
        }
        return (Boolean)s_aRWLock.readLocked(() -> (Boolean)s_aDefaultFeatures.get((Object)eXMLParserFeature));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return (ICommonsMap)s_aRWLock.readLocked(() -> s_aDefaultFeatures.getClone());
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        s_aRWLock.writeLocked(() -> {
            Boolean cfr_ignored_0 = (Boolean)s_aDefaultFeatures.put((Object)eXMLParserFeature, (Object)bl);
        });
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        s_aRWLock.writeLocked(() -> {
            if (bl == null) {
                s_aDefaultFeatures.remove((Object)eXMLParserFeature);
            } else {
                s_aDefaultFeatures.put((Object)eXMLParserFeature, (Object)bl);
            }
        });
    }

    public static void setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null) {
            s_aRWLock.writeLocked(() -> s_aDefaultFeatures.putAll(map));
        }
    }

    @Nonnull
    public static EChange removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)s_aRWLock.writeLocked(() -> s_aDefaultFeatures.removeObject((Object)eXMLParserFeature));
    }

    @Nonnull
    public static EChange removeAllFeatures() {
        return (EChange)s_aRWLock.writeLocked(() -> s_aDefaultFeatures.removeAll());
    }

    public static boolean requiresNewXMLParser() {
        return s_aRWLock.readLocked(() -> {
            if (s_bDefaultRequiresNewXMLParserExplicitly) {
                return true;
            }
            if (!s_bDefaultNamespaceAware || s_bDefaultValidating || s_bDefaultIgnoringElementContentWhitespace || !s_bDefaultExpandEntityReferences || !s_bDefaultIgnoringComments || !s_bDefaultCoalescing || s_aDefaultSchema != null || s_bDefaultXIncludeAware || s_aDefaultProperties.isNotEmpty() || s_aDefaultFeatures.isNotEmpty()) {
                return true;
            }
            return s_aDefaultEntityResolver != null;
        });
    }

    @Nullable
    public static EntityResolver getEntityResolver() {
        return (EntityResolver)s_aRWLock.readLocked(() -> s_aDefaultEntityResolver);
    }

    public static void setEntityResolver(@Nullable EntityResolver entityResolver) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultEntityResolver = entityResolver;
            return s_aDefaultEntityResolver;
        });
    }

    @Nullable
    public static ErrorHandler getErrorHandler() {
        return (ErrorHandler)s_aRWLock.readLocked(() -> s_aDefaultErrorHandler);
    }

    public static void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultErrorHandler = errorHandler;
            return s_aDefaultErrorHandler;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IExceptionCallback<Throwable>> exceptionCallbacks() {
        return s_aDefaultExceptionCallbacks;
    }

    public static boolean isRequiresNewXMLParserExplicitly() {
        return s_aRWLock.readLocked(() -> s_bDefaultRequiresNewXMLParserExplicitly);
    }

    public static void setRequiresNewXMLParserExplicitly(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultRequiresNewXMLParserExplicitly = bl;
            return s_bDefaultRequiresNewXMLParserExplicitly;
        });
    }

    static {
        s_bDefaultXIncludeAware = false;
        s_aDefaultProperties = new CommonsEnumMap(EXMLParserProperty.class);
        s_aDefaultFeatures = new CommonsEnumMap(EXMLParserFeature.class);
        s_aDefaultErrorHandler = new LoggingSAXErrorHandler();
        s_aDefaultExceptionCallbacks = new CallbackList();
        s_aDefaultExceptionCallbacks.add((ICallback)new XMLLoggingExceptionCallback());
        s_bDefaultRequiresNewXMLParserExplicitly = false;
        s_aInstance = new DOMReaderDefaultSettings();
    }
}

