/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.mock;

import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.File;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WSTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSTestHelper.class);

    private WSTestHelper() {
    }

    @Nonnegative
    public static int testIfAllSunJaxwsFilesAreValid(@Nonnull String string, boolean bl) {
        File file = new File(string, "sun-jaxws.xml");
        if (file.isFile()) {
            LOGGER.info("Checking file " + file.getAbsolutePath());
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(file);
            if (iMicroDocument == null) {
                LOGGER.warn("The file is invalid XML!");
                if (!bl) {
                    throw new IllegalStateException("The file is invalid XML!");
                }
            } else {
                for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("endpoint")) {
                    Class<?> clazz;
                    String string2;
                    String string3;
                    block12: {
                        WebService webService;
                        Class<?> clazz2;
                        String string4;
                        block11: {
                            string3 = iMicroElement.getAttributeValue("name");
                            string4 = iMicroElement.getAttributeValue("implementation");
                            clazz2 = null;
                            try {
                                clazz2 = Class.forName(string4);
                            }
                            catch (Exception exception) {
                                string2 = "The implementation class '" + string4 + "' of endpoint '" + string3 + "' is invalid - " + exception.getMessage();
                                LOGGER.warn(string2);
                                if (bl) break block11;
                                throw new IllegalStateException(string2);
                            }
                        }
                        if (clazz2 == null) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Implementation class '" + string4 + "' found");
                        }
                        if ((webService = clazz2.getAnnotation(WebService.class)) == null) {
                            string2 = "The implementation class '" + string4 + "' is missing the @WebService annotation";
                            LOGGER.warn(string2);
                            if (bl) continue;
                            throw new IllegalStateException(string2);
                        }
                        string2 = webService.endpointInterface();
                        clazz = null;
                        try {
                            clazz = Class.forName(string2);
                        }
                        catch (Exception exception) {
                            String string5 = "The endpoint interface class '" + string2 + "' of implementation class '" + string4 + "' is invalid - " + exception.getMessage();
                            LOGGER.warn(string5);
                            if (bl) break block12;
                            throw new IllegalStateException(string5);
                        }
                    }
                    if (clazz == null || clazz.isInterface()) continue;
                    String string6 = "The endpoint interface class '" + string2 + "' of endpoint '" + string3 + "' is not an interface!";
                    LOGGER.warn(string6);
                    if (bl) continue;
                    throw new IllegalStateException(string6);
                }
            }
        }
        return 0;
    }

    @Nonnegative
    public static int testIfAllSunJaxwsFilesAreValid(boolean bl) {
        int n = 0;
        n += WSTestHelper.testIfAllSunJaxwsFilesAreValid("src/main/resources/WEB-INF", bl);
        return n += WSTestHelper.testIfAllSunJaxwsFilesAreValid("src/main/webapp/WEB-INF", bl);
    }

    public static void testIfAllSunJaxwsFilesAreValid() {
        WSTestHelper.testIfAllSunJaxwsFilesAreValid(false);
    }
}

