/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.functional.ITriConsumer;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.commons.wrapper.Wrapper;
import com.helger.xml.CXMLRegEx;
import com.helger.xml.microdom.AbstractMicroNodeWithChildren;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroAttribute;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroAttribute;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicroElement
extends AbstractMicroNodeWithChildren
implements IMicroElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroElement.class);
    private String m_sNamespaceURI;
    private final String m_sTagName;
    private ICommonsOrderedMap<IMicroQName, MicroAttribute> m_aAttrs;

    public MicroElement(@Nonnull @Nonempty String string) {
        this(null, string);
    }

    public MicroElement(@Nullable String string, @Nonnull @Nonempty String string2) {
        int n;
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"TagName");
        this.m_sNamespaceURI = string;
        int n2 = n = string != null ? string2.indexOf(58) : -1;
        if (n == -1) {
            this.m_sTagName = string2;
        } else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Removing micro element namespace prefix '" + string2.substring(0, n) + "' from tag name '" + string2 + "'");
            }
            this.m_sTagName = string2.substring(n + 1);
        }
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME_QUICK.matcher(this.m_sTagName).matches() && !CXMLRegEx.PATTERN_NAME.matcher(this.m_sTagName).matches()) {
            throw new IllegalArgumentException("The micro element tag name '" + this.m_sTagName + "' is not a valid element name!");
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.ELEMENT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public boolean hasAttributes() {
        return this.m_aAttrs != null && this.m_aAttrs.isNotEmpty();
    }

    @Override
    public boolean hasNoAttributes() {
        return this.m_aAttrs == null || this.m_aAttrs.isEmpty();
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs == null ? 0 : this.m_aAttrs.size();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<? extends IMicroAttribute> getAllAttributeObjs() {
        if (this.hasNoAttributes()) {
            return null;
        }
        return this.m_aAttrs.copyOfValues();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public ICommonsOrderedMap<IMicroQName, String> getAllQAttributes() {
        if (this.hasNoAttributes()) {
            return null;
        }
        return new CommonsLinkedHashMap(this.m_aAttrs.values(), IMicroAttribute::getAttributeQName, IMicroAttribute::getAttributeValue);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMicroQName> getAllAttributeQNames() {
        if (this.hasNoAttributes()) {
            return null;
        }
        return this.m_aAttrs.copyOfKeySet();
    }

    @Override
    public void forAllAttributes(@Nonnull Consumer<? super IMicroAttribute> consumer) {
        if (this.m_aAttrs != null) {
            this.m_aAttrs.forEachValue(consumer);
        }
    }

    @Override
    public void forAllAttributes(@Nonnull BiConsumer<? super IMicroQName, ? super String> biConsumer) {
        if (this.m_aAttrs != null) {
            this.m_aAttrs.forEachValue(microAttribute -> biConsumer.accept(microAttribute.getAttributeQName(), microAttribute.getAttributeValue()));
        }
    }

    @Override
    public void forAllAttributes(@Nonnull ITriConsumer<? super String, ? super String, ? super String> iTriConsumer) {
        if (this.m_aAttrs != null) {
            this.m_aAttrs.forEachValue(microAttribute -> iTriConsumer.accept((Object)microAttribute.getNamespaceURI(), (Object)microAttribute.getAttributeName(), (Object)microAttribute.getAttributeValue()));
        }
    }

    @Override
    @Nullable
    public MicroAttribute getAttributeObj(@Nullable IMicroQName iMicroQName) {
        return iMicroQName == null || this.m_aAttrs == null ? null : (MicroAttribute)this.m_aAttrs.get((Object)iMicroQName);
    }

    @Nullable
    private static <DSTTYPE> DSTTYPE _getConvertedToType(@Nullable String string, @Nonnull Class<DSTTYPE> clazz) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (DSTTYPE)TypeConverter.convert((Object)string, clazz);
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getAttributeValueWithConversion(@Nullable IMicroQName iMicroQName, @Nonnull Class<DSTTYPE> clazz) {
        String string = this.getAttributeValue(iMicroQName);
        return MicroElement._getConvertedToType(string, clazz);
    }

    @Override
    public boolean hasAttribute(@Nullable IMicroQName iMicroQName) {
        return this.m_aAttrs != null && iMicroQName != null && this.m_aAttrs.containsKey((Object)iMicroQName);
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable IMicroQName iMicroQName) {
        if (this.m_aAttrs == null || iMicroQName == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aAttrs.removeObject((Object)iMicroQName);
    }

    @Override
    @Nonnull
    public MicroElement setAttribute(@Nonnull IMicroQName iMicroQName, @Nullable String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        if (string != null) {
            if (this.m_aAttrs == null) {
                this.m_aAttrs = new CommonsLinkedHashMap();
            }
            this.m_aAttrs.put((Object)iMicroQName, (Object)new MicroAttribute(iMicroQName, string));
        } else {
            this.removeAttribute(iMicroQName);
        }
        return this;
    }

    @Override
    @Nonnull
    public EChange removeAllAttributes() {
        if (this.m_aAttrs == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aAttrs.removeAll();
    }

    @Override
    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonnull
    public EChange setNamespaceURI(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sNamespaceURI, (Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_sNamespaceURI = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getLocalName() {
        return this.m_sNamespaceURI == null ? null : this.m_sTagName;
    }

    @Override
    @Nonnull
    public String getTagName() {
        return this.m_sTagName;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllChildElementsRecursive() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        MicroElement._forAllChildElements(this, null, arg_0 -> MicroElement.lambda$getAllChildElementsRecursive$2((ICommonsList)commonsArrayList, arg_0));
        return commonsArrayList;
    }

    private static boolean _containsChildElementRecursive(@Nonnull IMicroNode iMicroNode2, @Nullable Predicate<? super IMicroElement> predicate) {
        return iMicroNode2.containsAnyChild(iMicroNode -> {
            if (iMicroNode.isElement()) {
                IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                if (predicate == null || predicate.test(iMicroElement)) {
                    return true;
                }
            } else if (iMicroNode.isContainer() && MicroElement._containsChildElementRecursive(iMicroNode, predicate)) {
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean containsAnyChildElement(@Nullable Predicate<? super IMicroElement> predicate) {
        return MicroElement._containsChildElementRecursive(this, predicate);
    }

    @Nonnull
    private static EContinue _forAllChildElementsBreakable(@Nonnull IMicroNode iMicroNode2, @Nullable Predicate<? super IMicroElement> predicate, @Nonnull Function<? super IMicroElement, EContinue> function) {
        return iMicroNode2.forAllChildrenBreakable(iMicroNode -> {
            if (iMicroNode.isElement()) {
                IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                if ((predicate == null || predicate.test(iMicroElement)) && ((EContinue)function.apply(iMicroElement)).isBreak()) {
                    return EContinue.BREAK;
                }
            } else if (iMicroNode.isContainer() && MicroElement._forAllChildElementsBreakable(iMicroNode, predicate, function).isBreak()) {
                return EContinue.BREAK;
            }
            return EContinue.CONTINUE;
        });
    }

    private static IMicroElement _findFirstChildElement(@Nonnull IMicroNode iMicroNode, @Nullable Predicate<? super IMicroElement> predicate) {
        Wrapper wrapper = new Wrapper();
        MicroElement._forAllChildElementsBreakable(iMicroNode, predicate, iMicroElement -> {
            assert (wrapper.isNotSet());
            wrapper.set(iMicroElement);
            return EContinue.BREAK;
        });
        return (IMicroElement)wrapper.get();
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nullable Predicate<? super IMicroElement> predicate) {
        return MicroElement._findFirstChildElement(this, predicate);
    }

    private static void _forAllChildElements(@Nonnull IMicroNode iMicroNode2, @Nullable Predicate<? super IMicroElement> predicate, @Nonnull Consumer<? super IMicroElement> consumer) {
        iMicroNode2.forAllChildren(iMicroNode -> {
            if (iMicroNode.isElement()) {
                IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                if (predicate == null || predicate.test(iMicroElement)) {
                    consumer.accept(iMicroElement);
                }
            } else if (iMicroNode.isContainer()) {
                MicroElement._forAllChildElements(iMicroNode, predicate, consumer);
            }
        });
    }

    @Override
    public void forAllChildElements(@Nullable Predicate<? super IMicroElement> predicate, @Nonnull Consumer<? super IMicroElement> consumer) {
        MicroElement._forAllChildElements(this, predicate, consumer);
    }

    @Override
    @Nonnull
    public EContinue forAllChildElementsBreakable(@Nullable Predicate<? super IMicroElement> predicate, @Nonnull Function<? super IMicroElement, EContinue> function) {
        return MicroElement._forAllChildElementsBreakable(this, predicate, function);
    }

    @Override
    @Nonnull
    public IMicroElement getClone() {
        MicroElement microElement = new MicroElement(this.m_sNamespaceURI, this.m_sTagName);
        if (this.m_aAttrs != null) {
            microElement.m_aAttrs = new CommonsLinkedHashMap(this.m_aAttrs);
        }
        this.forAllChildren(iMicroNode -> microElement.appendChild((IMicroNode)iMicroNode.getClone()));
        return microElement;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!super.isEqualContent(iMicroNode)) {
            return false;
        }
        MicroElement microElement = (MicroElement)iMicroNode;
        return EqualsHelper.equals((Object)this.m_sNamespaceURI, (Object)microElement.m_sNamespaceURI) && this.m_sTagName.equals(microElement.m_sTagName) && EqualsHelper.equals(this.m_aAttrs, microElement.m_aAttrs);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("namespace", (Object)this.m_sNamespaceURI).append("tagname", (Object)this.m_sTagName).appendIfNotNull("attrs", this.m_aAttrs).getToString();
    }

    private static /* synthetic */ void lambda$getAllChildElementsRecursive$2(ICommonsList iCommonsList, IMicroElement iMicroElement) {
        iCommonsList.add((Object)iMicroElement);
        iCommonsList.addAll(iMicroElement.getAllChildElementsRecursive());
    }
}

