/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EXMLIncorrectCharacterHandling {
    THROW_EXCEPTION(true, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
            throw new IllegalArgumentException("XML content contains invalid character data: '" + string + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(set));
        }
    }
    ,
    WRITE_TO_FILE_NO_LOG(false, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
        }
    }
    ,
    WRITE_TO_FILE_LOG_WARNING(true, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
            if (s_aLogger.isWarnEnabled()) {
                s_aLogger.warn("XML content contains invalid character data (no replacement): '" + string + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(set));
            }
        }
    }
    ,
    DO_NOT_WRITE_NO_LOG(false, true){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
        }
    }
    ,
    DO_NOT_WRITE_LOG_WARNING(true, true){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
            if (s_aLogger.isWarnEnabled()) {
                s_aLogger.warn("XML content contains invalid character data (will replace): '" + string + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(set));
            }
        }
    };

    public static final EXMLIncorrectCharacterHandling DEFAULT;
    private static final Logger s_aLogger;
    private final boolean m_bIsNotifyRequired;
    private final boolean m_bReplaceWithNothing;

    private EXMLIncorrectCharacterHandling(boolean bl, boolean bl2) {
        this.m_bIsNotifyRequired = bl;
        this.m_bReplaceWithNothing = bl2;
    }

    public boolean isTestRequired() {
        return this.m_bIsNotifyRequired || this.m_bReplaceWithNothing;
    }

    public boolean isNotifyRequired() {
        return this.m_bIsNotifyRequired;
    }

    public boolean isReplaceWithNothing() {
        return this.m_bReplaceWithNothing;
    }

    @Nonnull
    private static String _getAsString(@Nonnull Set<Character> set) {
        if (set.isEmpty()) {
            return "NONE";
        }
        return StringHelper.getImplodedMapped((String)", ", set, c -> "0x" + StringHelper.getHexStringLeadingZero((int)c.charValue(), (int)2));
    }

    public abstract void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String var1, @Nonnull Set<Character> var2);

    static {
        DEFAULT = WRITE_TO_FILE_NO_LOG;
        s_aLogger = LoggerFactory.getLogger(EXMLIncorrectCharacterHandling.class);
    }
}

