/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.IHasOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLMapHandler {
    public static final String ELEMENT_MAPPING = "mapping";
    public static final String ELEMENT_MAP = "map";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_VALUE = "value";
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLMapHandler.class);
    private static final XMLMapHandler s_aInstance = new XMLMapHandler();

    private XMLMapHandler() {
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> readMap(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        return XMLMapHandler.readMap(iHasInputStream.getInputStream());
    }

    @Nonnull
    public static ESuccess readMap(@Nonnull IHasInputStream iHasInputStream, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        return XMLMapHandler.readMap(iHasInputStream.getInputStream(), map);
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> readMap(@Nonnull @WillClose InputStream inputStream) {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        if (XMLMapHandler.readMap(inputStream, (Map<String, String>)commonsHashMap).isFailure()) {
            return null;
        }
        return commonsHashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static ESuccess readMap(@Nonnull @WillClose InputStream inputStream, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull(map, (String)"TargetMap");
        try (InputStream inputStream2 = inputStream;){
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream);
            if (iMicroDocument == null) return ESuccess.FAILURE;
            XMLMapHandler.readMap(iMicroDocument.getDocumentElement(), map);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (Exception exception) {
            if (!s_aLogger.isWarnEnabled()) return ESuccess.FAILURE;
            s_aLogger.warn("Failed to read mapping resource '" + inputStream + "'", (Throwable)exception);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess readMap(@Nonnull IMicroElement iMicroElement, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ParentElement");
        ValueEnforcer.notNull(map, (String)"TargetMap");
        try {
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_MAP)) {
                String string = iMicroElement2.getAttributeValue(ATTR_KEY);
                if (string == null) {
                    s_aLogger.warn("Ignoring mapping element because key is null");
                    continue;
                }
                String string2 = iMicroElement2.getAttributeValue(ATTR_VALUE);
                if (string2 == null) {
                    s_aLogger.warn("Ignoring mapping element because value is null");
                    continue;
                }
                if (map.containsKey(string) && s_aLogger.isWarnEnabled()) {
                    s_aLogger.warn("Key '" + string + "' is already contained - overwriting!");
                }
                map.put(string, string2);
            }
            return ESuccess.SUCCESS;
        }
        catch (Exception exception) {
            if (s_aLogger.isWarnEnabled()) {
                s_aLogger.warn("Failed to read mapping document", (Throwable)exception);
            }
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static IMicroDocument createMapDocument(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"Map");
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_MAPPING);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            IMicroElement iMicroElement2 = iMicroElement.appendElement(ELEMENT_MAP);
            iMicroElement2.setAttribute(ATTR_KEY, entry.getKey());
            iMicroElement2.setAttribute(ATTR_VALUE, entry.getValue());
        }
        return microDocument;
    }

    @Nonnull
    public static ESuccess writeMap(@Nonnull Map<String, String> map, @Nonnull IHasOutputStream iHasOutputStream) {
        ValueEnforcer.notNull((Object)iHasOutputStream, (String)"OutputStreamProvider");
        return XMLMapHandler.writeMap(map, iHasOutputStream.getOutputStream(EAppend.DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeMap(@Nonnull Map<String, String> map, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull(map, (String)"Map");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            IMicroDocument iMicroDocument = XMLMapHandler.createMapDocument(map);
            ESuccess eSuccess = MicroWriter.writeToStream(iMicroDocument, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }
}

