/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.xml.microdom.IMicroNode;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class MicroRecursiveIterator
implements IIterableIterator<IMicroNode> {
    private final ICommonsList<IMicroNode> m_aOpen = new CommonsArrayList();

    public MicroRecursiveIterator(@Nonnull IMicroNode iMicroNode) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        this.m_aOpen.add((Object)iMicroNode);
    }

    public boolean hasNext() {
        return !this.m_aOpen.isEmpty();
    }

    public IMicroNode next() {
        if (this.m_aOpen.isEmpty()) {
            throw new NoSuchElementException();
        }
        IMicroNode iMicroNode = (IMicroNode)this.m_aOpen.remove(0);
        if (iMicroNode.hasChildren()) {
            this.m_aOpen.addAll(0, iMicroNode.getAllChildren());
        }
        return iMicroNode;
    }
}

