/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.error.IError;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.log.LogHelper;
import com.helger.xml.transform.AbstractTransformErrorListener;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@CodingStyleguideUnaware(value="logger too visible by purpose")
public class LoggingTransformErrorListener
extends AbstractTransformErrorListener {
    protected static final Logger s_aLogger = LoggerFactory.getLogger(LoggingTransformErrorListener.class);
    private final Locale m_aDisplayLocale;

    public LoggingTransformErrorListener(@Nonnull Locale locale) {
        this.m_aDisplayLocale = (Locale)ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
    }

    @Nonnull
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Override
    protected void internalLog(@Nonnull IError iError) {
        IErrorLevel iErrorLevel = iError.getErrorLevel();
        String string = iError.getAsString(this.m_aDisplayLocale);
        LogHelper.log((Logger)s_aLogger, (IErrorLevel)iErrorLevel, (String)string);
    }
}

