/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.location.ErrorLocation;
import com.helger.commons.error.location.IErrorLocation;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.sax.ISAXErrorHandler;
import javax.annotation.Nonnull;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSAXErrorHandler
implements ISAXErrorHandler {
    protected AbstractSAXErrorHandler() {
    }

    @Nonnull
    public static IError getSaxParseError(@Nonnull IErrorLevel iErrorLevel, @Nonnull SAXParseException sAXParseException) {
        String string = StringHelper.getConcatenatedOnDemand((String)sAXParseException.getPublicId(), (String)"/", (String)sAXParseException.getSystemId());
        return ((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builder().setErrorLevel(iErrorLevel)).setErrorLocation((IErrorLocation)new ErrorLocation(string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()))).setErrorText("[SAX] " + sAXParseException.getMessage())).setLinkedException((Throwable)sAXParseException)).build();
    }

    protected abstract void internalLog(@Nonnull IErrorLevel var1, @Nonnull SAXParseException var2);

    @Override
    public final void warning(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.WARN, sAXParseException);
    }

    @Override
    public final void error(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.ERROR, sAXParseException);
    }

    @Override
    public final void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.FATAL_ERROR, sAXParseException);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).toString();
    }
}

