/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.factory.IFactory;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.pool.IMutableObjectPool;
import com.helger.commons.pool.ObjectPool;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.timing.StopWatch;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReaderFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@ThreadSafe
public final class SAXReader {
    private static final IMutableStatisticsHandlerTimer s_aSaxTimerHdl = StatisticsManager.getTimerHandler((String)SAXReader.class.getName());
    private static final IMutableStatisticsHandlerCounter s_aSaxSuccessCounterHdl = StatisticsManager.getCounterHandler((String)(SAXReader.class.getName() + "$success"));
    private static final IMutableStatisticsHandlerCounter s_aSaxErrorCounterHdl = StatisticsManager.getCounterHandler((String)(SAXReader.class.getName() + "$error"));
    private static final IMutableObjectPool<XMLReader> s_aSAXPool = new ObjectPool(5, (IFactory)new SAXReaderFactory());
    private static final SAXReader s_aInstance = new SAXReader();

    private SAXReader() {
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull File file, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(file), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull URI uRI, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(uRI), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull URL uRL, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(uRL), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull IHasInputStream iHasInputStream, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(iHasInputStream), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull IReadableResource iReadableResource, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(iReadableResource), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull CharSequence charSequence, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(charSequence), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull String string, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(string), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull char[] cArray, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(cArray), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(cArray, n, n2), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull byte[] byArray, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byArray), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byArray, n, n2), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull ByteBuffer byteBuffer, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byteBuffer), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull @WillClose InputStream inputStream, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        try {
            ESuccess eSuccess = SAXReader.readXMLSAX(InputSourceFactory.create(inputStream), iSAXReaderSettings);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull @WillClose Reader reader, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        try {
            ESuccess eSuccess = SAXReader.readXMLSAX(InputSourceFactory.create(reader), iSAXReaderSettings);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputSource inputSource, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ESuccess eSuccess;
        XMLReader xMLReader;
        boolean bl;
        block17: {
            ValueEnforcer.notNull((Object)inputSource, (String)"InputStream");
            ValueEnforcer.notNull((Object)iSAXReaderSettings, (String)"Settings");
            bl = false;
            if (iSAXReaderSettings.requiresNewXMLParser()) {
                xMLReader = SAXReaderFactory.createXMLReader();
            } else {
                xMLReader = (XMLReader)s_aSAXPool.borrowObject();
                bl = true;
            }
            StopWatch stopWatch = StopWatch.createdStarted();
            iSAXReaderSettings.applyToSAXReader(xMLReader);
            xMLReader.parse(inputSource);
            s_aSaxSuccessCounterHdl.increment();
            s_aSaxTimerHdl.addTime(stopWatch.stopAndGetMillis());
            eSuccess = ESuccess.SUCCESS;
            if (!bl) break block17;
            s_aSAXPool.returnObject((Object)xMLReader);
        }
        StreamHelper.close((AutoCloseable)inputSource.getByteStream());
        StreamHelper.close((AutoCloseable)inputSource.getCharacterStream());
        return eSuccess;
        {
            catch (Throwable throwable) {
                try {
                    if (bl) {
                        s_aSAXPool.returnObject((Object)xMLReader);
                    }
                    throw throwable;
                }
                catch (SAXParseException sAXParseException) {
                    boolean bl2 = false;
                    if (iSAXReaderSettings.getErrorHandler() != null) {
                        try {
                            iSAXReaderSettings.getErrorHandler().fatalError(sAXParseException);
                            bl2 = true;
                        }
                        catch (SAXException sAXException) {
                            // empty catch block
                        }
                    }
                    if (!bl2) {
                        iSAXReaderSettings.getExceptionHandler().onException((Throwable)sAXParseException);
                    }
                    StreamHelper.close((AutoCloseable)inputSource.getByteStream());
                    StreamHelper.close((AutoCloseable)inputSource.getCharacterStream());
                }
                catch (Throwable throwable2) {
                    try {
                        iSAXReaderSettings.getExceptionHandler().onException(throwable2);
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        StreamHelper.close((AutoCloseable)inputSource.getByteStream());
                        StreamHelper.close((AutoCloseable)inputSource.getCharacterStream());
                    }
                }
            }
        }
        s_aSaxErrorCounterHdl.increment();
        return ESuccess.FAILURE;
    }
}

