/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.location.ErrorLocation;
import com.helger.commons.error.location.IErrorLocation;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.sax.ISAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSAXErrorHandler
implements ISAXErrorHandler {
    private final ErrorHandler m_aWrappedErrorHandler;

    protected AbstractSAXErrorHandler() {
        this.m_aWrappedErrorHandler = null;
    }

    @Deprecated
    public AbstractSAXErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.m_aWrappedErrorHandler = errorHandler;
    }

    @Nullable
    @Deprecated
    public ErrorHandler getWrappedErrorHandler() {
        return this.m_aWrappedErrorHandler;
    }

    @Nonnull
    public static IError getSaxParseError(@Nonnull IErrorLevel iErrorLevel, @Nonnull SAXParseException sAXParseException) {
        String string = StringHelper.getConcatenatedOnDemand((String)sAXParseException.getPublicId(), (String)"/", (String)sAXParseException.getSystemId());
        return ((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builder().setErrorLevel(iErrorLevel)).setErrorLocation((IErrorLocation)new ErrorLocation(string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()))).setErrorText("[SAX] " + sAXParseException.getMessage())).setLinkedException((Throwable)sAXParseException)).build();
    }

    protected abstract void internalLog(@Nonnull IErrorLevel var1, @Nonnull SAXParseException var2);

    @Override
    public final void warning(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.WARN, sAXParseException);
        ErrorHandler errorHandler = this.getWrappedErrorHandler();
        if (errorHandler != null) {
            errorHandler.warning(sAXParseException);
        }
    }

    @Override
    public final void error(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.ERROR, sAXParseException);
        ErrorHandler errorHandler = this.getWrappedErrorHandler();
        if (errorHandler != null) {
            errorHandler.error(sAXParseException);
        }
    }

    @Override
    public final void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.internalLog((IErrorLevel)EErrorLevel.FATAL_ERROR, sAXParseException);
        ErrorHandler errorHandler = this.getWrappedErrorHandler();
        if (errorHandler != null) {
            errorHandler.fatalError(sAXParseException);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("wrappedErrorHandler", (Object)this.m_aWrappedErrorHandler).toString();
    }
}

