/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.CommonsWeakHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.IMicroTypeConverterCallback;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistry;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MicroTypeConverterRegistry
implements IMicroTypeConverterRegistry {
    public static final boolean DEFAULT_USE_CLASS_HIERARCHY = false;
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroTypeConverterRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsMap<Class<?>, IMicroTypeConverter> m_aMap = new CommonsWeakHashMap();
    private boolean m_bUseClassHierarchy = false;

    private MicroTypeConverterRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static MicroTypeConverterRegistry getInstance() {
        MicroTypeConverterRegistry microTypeConverterRegistry = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return microTypeConverterRegistry;
    }

    public boolean isUseClassHierarchy() {
        return this.m_bUseClassHierarchy;
    }

    public void setUseClassHierarchy(boolean bl) {
        if (this.m_bUseClassHierarchy != bl) {
            this.m_bUseClassHierarchy = bl;
            this.reinitialize();
        }
    }

    @Override
    public void registerMicroElementTypeConverter(@Nonnull Class<?> clazz, @Nonnull IMicroTypeConverter iMicroTypeConverter) {
        this._registerMicroElementTypeConverter(clazz, iMicroTypeConverter);
    }

    private void _registerMicroElementTypeConverter(@Nonnull Class<?> clazz, @Nonnull IMicroTypeConverter iMicroTypeConverter) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        ValueEnforcer.notNull((Object)iMicroTypeConverter, (String)"Converter");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + clazz + " is already registered!");
            }
            if (this.m_bUseClassHierarchy) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator((Class)clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || this.m_aMap.containsKey((Object)clazz2)) continue;
                    this.m_aMap.put((Object)clazz2, (Object)iMicroTypeConverter);
                    if (!s_aLogger.isDebugEnabled()) continue;
                    s_aLogger.debug("Registered micro type converter for '" + clazz2.toString() + "'");
                }
            } else {
                this.m_aMap.put((Object)clazz, (Object)iMicroTypeConverter);
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Registered micro type converter for '" + clazz.toString() + "'");
                }
            }
        });
    }

    @Nullable
    public IMicroTypeConverter getConverterToMicroElement(@Nullable Class<?> clazz) {
        return (IMicroTypeConverter)this.m_aRWLock.readLocked(() -> (IMicroTypeConverter)this.m_aMap.get((Object)clazz));
    }

    @Nullable
    public IMicroTypeConverter getConverterToNative(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"DestClass");
        return (IMicroTypeConverter)this.m_aRWLock.readLocked(() -> {
            IMicroTypeConverter iMicroTypeConverter;
            block3: {
                block2: {
                    iMicroTypeConverter = (IMicroTypeConverter)this.m_aMap.get((Object)clazz);
                    if (iMicroTypeConverter == null) break block2;
                    if (!s_aLogger.isTraceEnabled()) break block3;
                    s_aLogger.trace("Using micro type converter " + iMicroTypeConverter + " for class " + clazz + " based on direct match");
                    break block3;
                }
                if (this.m_bUseClassHierarchy) {
                    for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator((Class)clazz)) {
                        Class clazz2 = (Class)weakReference.get();
                        if (clazz2 == null || (iMicroTypeConverter = (IMicroTypeConverter)this.m_aMap.get((Object)clazz2)) == null) continue;
                        if (!s_aLogger.isTraceEnabled()) break;
                        s_aLogger.trace("Using micro type converter " + iMicroTypeConverter + " for class " + clazz + " based on " + clazz2);
                        break;
                    }
                }
            }
            return iMicroTypeConverter;
        });
    }

    public void iterateAllRegisteredMicroTypeConverters(@Nonnull IMicroTypeConverterCallback iMicroTypeConverterCallback) {
        Map.Entry entry;
        ICommonsMap iCommonsMap = (ICommonsMap)this.m_aRWLock.readLocked(() -> (ICommonsMap)this.m_aMap.getClone());
        Iterator iterator = iCommonsMap.entrySet().iterator();
        while (iterator.hasNext() && !iMicroTypeConverterCallback.call((Class)(entry = (Map.Entry)iterator.next()).getKey(), (IMicroTypeConverter)entry.getValue()).isBreak()) {
        }
    }

    @Nonnegative
    public int getRegisteredMicroTypeConverterCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aMap.size());
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMap.clear();
            for (IMicroTypeConverterRegistrarSPI iMicroTypeConverterRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IMicroTypeConverterRegistrarSPI.class)) {
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Calling registerMicroTypeConverter on " + iMicroTypeConverterRegistrarSPI.getClass().getName());
                }
                iMicroTypeConverterRegistrarSPI.registerMicroTypeConverter(this);
            }
        });
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug(this.getRegisteredMicroTypeConverterCount() + " micro type converters registered");
        }
    }

    private static final class SingletonHolder {
        private static final MicroTypeConverterRegistry s_aInstance = new MicroTypeConverterRegistry();

        private SingletonHolder() {
        }
    }
}

