/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.filter.IFilter;
import com.helger.commons.function.ITriConsumer;
import com.helger.commons.mutable.MutableInt;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroAttribute;
import com.helger.xml.microdom.IMicroNodeWithChildren;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMicroElement
extends IMicroNodeWithChildren {
    public boolean hasAttributes();

    public boolean hasNoAttributes();

    @Nonnegative
    public int getAttributeCount();

    default public boolean hasAttribute(@Nullable String string) {
        return this.hasAttribute(null, string);
    }

    default public boolean hasAttribute(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText((String)string2)) {
            return false;
        }
        return this.hasAttribute(new MicroQName(string, string2));
    }

    public boolean hasAttribute(@Nullable IMicroQName var1);

    @Nullable
    default public IMicroAttribute getAttributeObj(@Nullable String string) {
        return this.getAttributeObj(null, string);
    }

    @Nullable
    default public IMicroAttribute getAttributeObj(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText((String)string2)) {
            return null;
        }
        return this.getAttributeObj(new MicroQName(string, string2));
    }

    @Nullable
    public IMicroAttribute getAttributeObj(@Nullable IMicroQName var1);

    @Nullable
    default public String getAttributeValue(@Nullable String string) {
        return this.getAttributeValue(null, string);
    }

    @Nullable
    default public String getAttributeValue(@Nullable String string, @Nullable String string2) {
        return this.getAttributeValue(new MicroQName(string, string2));
    }

    @Nullable
    default public String getAttributeValue(@Nullable IMicroQName iMicroQName) {
        IMicroAttribute iMicroAttribute = this.getAttributeObj(iMicroQName);
        return iMicroAttribute == null ? null : iMicroAttribute.getAttributeValue();
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAttributeValueWithConversion(@Nullable String string, @Nonnull Class<DSTTYPE> clazz) {
        return this.getAttributeValueWithConversion(null, string, clazz);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAttributeValueWithConversion(@Nullable String string, @Nullable String string2, @Nonnull Class<DSTTYPE> clazz) {
        return this.getAttributeValueWithConversion(new MicroQName(string, string2), clazz);
    }

    @Nullable
    public <DSTTYPE> DSTTYPE getAttributeValueWithConversion(@Nullable IMicroQName var1, @Nonnull Class<DSTTYPE> var2);

    default public boolean getAttributeValueAsBool(@Nullable String string, boolean bl) {
        return StringParser.parseBool((String)this.getAttributeValue(string), (boolean)bl);
    }

    default public boolean getAttributeValueAsBool(@Nullable String string, @Nullable String string2, boolean bl) {
        return StringParser.parseBool((String)this.getAttributeValue(string, string2), (boolean)bl);
    }

    default public boolean getAttributeValueAsBool(@Nullable IMicroQName iMicroQName, boolean bl) {
        return StringParser.parseBool((String)this.getAttributeValue(iMicroQName), (boolean)bl);
    }

    default public double getAttributeValueAsDouble(@Nullable String string, double d) {
        return StringParser.parseDouble((String)this.getAttributeValue(string), (double)d);
    }

    default public double getAttributeValueAsDouble(@Nullable String string, @Nullable String string2, double d) {
        return StringParser.parseDouble((String)this.getAttributeValue(string, string2), (double)d);
    }

    default public double getAttributeValueAsDouble(@Nullable IMicroQName iMicroQName, double d) {
        return StringParser.parseDouble((String)this.getAttributeValue(iMicroQName), (double)d);
    }

    default public float getAttributeValueAsFloat(@Nullable String string, float f) {
        return StringParser.parseFloat((String)this.getAttributeValue(string), (float)f);
    }

    default public float getAttributeValueAsFloat(@Nullable String string, @Nullable String string2, float f) {
        return StringParser.parseFloat((String)this.getAttributeValue(string, string2), (float)f);
    }

    default public float getAttributeValueAsFloat(@Nullable IMicroQName iMicroQName, float f) {
        return StringParser.parseFloat((String)this.getAttributeValue(iMicroQName), (float)f);
    }

    default public int getAttributeValueAsInt(@Nullable String string, int n) {
        return StringParser.parseInt((String)this.getAttributeValue(string), (int)n);
    }

    default public int getAttributeValueAsInt(@Nullable String string, @Nullable String string2, int n) {
        return StringParser.parseInt((String)this.getAttributeValue(string, string2), (int)n);
    }

    default public int getAttributeValueAsInt(@Nullable IMicroQName iMicroQName, int n) {
        return StringParser.parseInt((String)this.getAttributeValue(iMicroQName), (int)n);
    }

    default public long getAttributeValueAsLong(@Nullable String string, long l) {
        return StringParser.parseLong((String)this.getAttributeValue(string), (long)l);
    }

    default public long getAttributeValueAsLong(@Nullable String string, @Nullable String string2, long l) {
        return StringParser.parseLong((String)this.getAttributeValue(string, string2), (long)l);
    }

    default public long getAttributeValueAsLong(@Nullable IMicroQName iMicroQName, long l) {
        return StringParser.parseLong((String)this.getAttributeValue(iMicroQName), (long)l);
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<? extends IMicroAttribute> getAllAttributeObjs();

    @Nullable
    @ReturnsMutableCopy
    public ICommonsOrderedMap<IMicroQName, String> getAllQAttributes();

    @Nullable
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMicroQName> getAllAttributeQNames();

    public void forAllAttributes(@Nonnull Consumer<? super IMicroAttribute> var1);

    public void forAllAttributes(@Nonnull BiConsumer<? super IMicroQName, ? super String> var1);

    public void forAllAttributes(@Nonnull ITriConsumer<? super String, ? super String, ? super String> var1);

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull String string, @Nullable String string2) {
        return this.setAttribute((IMicroQName)new MicroQName(string), string2);
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, @Nullable String string3) {
        return this.setAttribute((IMicroQName)new MicroQName(string, string2), string3);
    }

    @Nonnull
    public IMicroElement setAttribute(@Nonnull IMicroQName var1, @Nullable String var2);

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull String string, @Nonnull IHasAttributeValue iHasAttributeValue) {
        return this.setAttribute((IMicroQName)new MicroQName(string), iHasAttributeValue);
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, @Nonnull IHasAttributeValue iHasAttributeValue) {
        return this.setAttribute((IMicroQName)new MicroQName(string, string2), iHasAttributeValue);
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull IMicroQName iMicroQName, @Nonnull IHasAttributeValue iHasAttributeValue) {
        ValueEnforcer.notNull((Object)iHasAttributeValue, (String)"AttrValueProvider");
        return this.setAttribute(iMicroQName, iHasAttributeValue.getAttrValue());
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull String string, boolean bl) {
        return this.setAttribute(string, Boolean.toString(bl));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, boolean bl) {
        return this.setAttribute(string, string2, Boolean.toString(bl));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull IMicroQName iMicroQName, boolean bl) {
        return this.setAttribute(iMicroQName, Boolean.toString(bl));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull String string, double d) {
        return this.setAttribute(string, Double.toString(d));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, double d) {
        return this.setAttribute(string, string2, Double.toString(d));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull IMicroQName iMicroQName, double d) {
        return this.setAttribute(iMicroQName, Double.toString(d));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull String string, float f) {
        return this.setAttribute(string, Float.toString(f));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, float f) {
        return this.setAttribute(string, string2, Float.toString(f));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull IMicroQName iMicroQName, float f) {
        return this.setAttribute(iMicroQName, Float.toString(f));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull String string, int n) {
        return this.setAttribute(string, Integer.toString(n));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, int n) {
        return this.setAttribute(string, string2, Integer.toString(n));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull IMicroQName iMicroQName, int n) {
        return this.setAttribute(iMicroQName, Integer.toString(n));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull String string, long l) {
        return this.setAttribute(string, Long.toString(l));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, long l) {
        return this.setAttribute(string, string2, Long.toString(l));
    }

    @Nonnull
    default public IMicroElement setAttribute(@Nonnull IMicroQName iMicroQName, long l) {
        return this.setAttribute(iMicroQName, Long.toString(l));
    }

    @Nonnull
    default public IMicroElement setAttributeWithConversion(@Nonnull String string, @Nullable Object object) {
        return this.setAttributeWithConversion(new MicroQName(string), object);
    }

    @Nonnull
    default public IMicroElement setAttributeWithConversion(@Nullable String string, @Nonnull String string2, @Nullable Object object) {
        return this.setAttributeWithConversion(new MicroQName(string, string2), object);
    }

    @Nonnull
    default public IMicroElement setAttributeWithConversion(@Nonnull IMicroQName iMicroQName, @Nullable Object object) {
        String string = (String)TypeConverter.convertIfNecessary((Object)object, String.class);
        return this.setAttribute(iMicroQName, string);
    }

    @Nonnull
    default public EChange removeAttribute(@Nullable String string) {
        return this.removeAttribute(null, string);
    }

    @Nonnull
    default public EChange removeAttribute(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText((String)string2)) {
            return EChange.UNCHANGED;
        }
        return this.removeAttribute(new MicroQName(string, string2));
    }

    @Nonnull
    public EChange removeAttribute(@Nullable IMicroQName var1);

    @Nonnull
    public EChange removeAllAttributes();

    @Nullable
    public String getNamespaceURI();

    @Nonnull
    public EChange setNamespaceURI(@Nullable String var1);

    default public boolean hasNamespaceURI() {
        return this.getNamespaceURI() != null;
    }

    default public boolean hasNoNamespaceURI() {
        return this.getNamespaceURI() == null;
    }

    default public boolean hasNamespaceURI(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getNamespaceURI(), (Object)string);
    }

    @Nullable
    public String getLocalName();

    default public boolean hasLocalName(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getLocalName(), (Object)string);
    }

    @Nonnull
    public String getTagName();

    default public boolean hasTagName(@Nullable String string) {
        return this.getTagName().equals(string);
    }

    default public boolean hasTagNameIgnoreCase(@Nullable String string) {
        return this.getTagName().equalsIgnoreCase(string);
    }

    @Nonnegative
    default public int getChildElementCount() {
        return this.getChildElementCount(null);
    }

    @Nonnegative
    default public int getChildElementCount(@Nullable Predicate<? super IMicroElement> predicate) {
        MutableInt mutableInt = new MutableInt();
        this.forAllChildElements(predicate, iMicroElement -> mutableInt.inc());
        return mutableInt.intValue();
    }

    @Nonnull
    public static IFilter<IMicroElement> filterNamespaceURI(@Nullable String string) {
        return (IFilter & Serializable)iMicroElement -> iMicroElement.hasNamespaceURI(string);
    }

    @Nonnull
    public static IFilter<IMicroElement> filterName(@Nullable String string) {
        return (IFilter & Serializable)iMicroElement -> iMicroElement.hasTagName(string);
    }

    @Nonnull
    public static IFilter<IMicroElement> filterNamespaceURIAndName(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText((String)string)) {
            return IMicroElement.filterName(string2);
        }
        return (IFilter & Serializable)iMicroElement -> iMicroElement.hasNamespaceURI(string) && iMicroElement.hasLocalName(string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<IMicroElement> getAllChildElements() {
        return this.getAllChildElements((Predicate<? super IMicroElement>)null);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<IMicroElement> getAllChildElements(@Nullable String string) {
        return this.getAllChildElements((Predicate<? super IMicroElement>)IMicroElement.filterName(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<IMicroElement> getAllChildElements(@Nullable String string, @Nullable String string2) {
        return this.getAllChildElements((Predicate<? super IMicroElement>)IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<IMicroElement> getAllChildElements(@Nullable Predicate<? super IMicroElement> predicate) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.forAllChildElements(predicate, arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllChildElementsRecursive();

    default public boolean hasChildElements() {
        return this.containsAnyChildElement(null);
    }

    default public boolean hasChildElements(@Nullable String string) {
        return this.containsAnyChildElement((Predicate<? super IMicroElement>)IMicroElement.filterName(string));
    }

    default public boolean hasChildElements(@Nullable String string, @Nullable String string2) {
        return this.containsAnyChildElement((Predicate<? super IMicroElement>)IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    public boolean containsAnyChildElement(@Nullable Predicate<? super IMicroElement> var1);

    @Nullable
    default public IMicroElement getFirstChildElement() {
        return this.findFirstChildElement(null);
    }

    @Nullable
    default public IMicroElement getFirstChildElement(@Nullable String string) {
        return this.findFirstChildElement((Predicate<? super IMicroElement>)IMicroElement.filterName(string));
    }

    @Nullable
    default public IMicroElement getFirstChildElement(@Nullable String string, @Nullable String string2) {
        return this.findFirstChildElement((Predicate<? super IMicroElement>)IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    @Nullable
    public IMicroElement findFirstChildElement(@Nullable Predicate<? super IMicroElement> var1);

    default public void forAllChildElements(@Nonnull Consumer<? super IMicroElement> consumer) {
        this.forAllChildElements(null, consumer);
    }

    public void forAllChildElements(@Nullable Predicate<? super IMicroElement> var1, @Nonnull Consumer<? super IMicroElement> var2);

    @Nonnull
    default public EContinue forAllChildElementsBreakable(@Nonnull Function<? super IMicroElement, EContinue> function) {
        return this.forAllChildElementsBreakable(null, function);
    }

    @Nonnull
    public EContinue forAllChildElementsBreakable(@Nullable Predicate<? super IMicroElement> var1, @Nonnull Function<? super IMicroElement, EContinue> var2);

    @Override
    @Nonnull
    public IMicroElement getClone();
}

