/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.CGlobal;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.log.LogHelper;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

@Immutable
@CodingStyleguideUnaware(value="logger too visible by purpose")
public class LoggingSAXErrorHandler
extends AbstractSAXErrorHandler {
    protected static final Logger s_aLogger = LoggerFactory.getLogger(LoggingSAXErrorHandler.class);

    public LoggingSAXErrorHandler() {
    }

    public LoggingSAXErrorHandler(@Nullable ErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getErrorMessage(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        return LoggingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException).getAsString(CGlobal.DEFAULT_LOCALE);
    }

    @Override
    protected void internalLog(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        LogHelper.log((Logger)s_aLogger, (IErrorLevel)iErrorLevel, (String)this.getErrorMessage(iErrorLevel, sAXParseException));
    }
}

