/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.ext.CommonsEnumMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.sax.LoggingSAXErrorHandler;
import com.helger.xml.serialize.read.XMLLoggingExceptionCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

@ThreadSafe
public final class SAXReaderDefaultSettings {
    public static final boolean DEFAULT_REQUIRES_NEW_XML_PARSER_EXPLICITLY = false;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static EntityResolver s_aDefaultEntityResolver;
    @GuardedBy(value="s_aRWLock")
    private static DTDHandler s_aDefaultDTDHandler;
    @GuardedBy(value="s_aRWLock")
    private static ContentHandler s_aDefaultContentHandler;
    @GuardedBy(value="s_aRWLock")
    private static ErrorHandler s_aDefaultErrorHandler;
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<EXMLParserProperty, Object> s_aDefaultProperties;
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<EXMLParserFeature, Boolean> s_aDefaultFeatures;
    @GuardedBy(value="s_aRWLock")
    private static IExceptionCallback<Throwable> s_aDefaultExceptionHandler;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultRequiresNewXMLParserExplicitly;
    private static final SAXReaderDefaultSettings s_aInstance;

    private SAXReaderDefaultSettings() {
    }

    @Nullable
    public static EntityResolver getEntityResolver() {
        return (EntityResolver)s_aRWLock.readLocked(() -> s_aDefaultEntityResolver);
    }

    public static void setEntityResolver(@Nullable EntityResolver entityResolver) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultEntityResolver = entityResolver;
            return s_aDefaultEntityResolver;
        });
    }

    @Nullable
    public static DTDHandler getDTDHandler() {
        return (DTDHandler)s_aRWLock.readLocked(() -> s_aDefaultDTDHandler);
    }

    public static void setDTDHandler(@Nullable DTDHandler dTDHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultDTDHandler = dTDHandler;
            return s_aDefaultDTDHandler;
        });
    }

    @Nullable
    public static ContentHandler getContentHandler() {
        return (ContentHandler)s_aRWLock.readLocked(() -> s_aDefaultContentHandler);
    }

    public static void setContentHandler(@Nullable ContentHandler contentHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultContentHandler = contentHandler;
            return s_aDefaultContentHandler;
        });
    }

    @Nullable
    public static ErrorHandler getErrorHandler() {
        return (ErrorHandler)s_aRWLock.readLocked(() -> s_aDefaultErrorHandler);
    }

    public static void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultErrorHandler = errorHandler;
            return s_aDefaultErrorHandler;
        });
    }

    @Nullable
    public static LexicalHandler getLexicalHandler() {
        return (LexicalHandler)SAXReaderDefaultSettings.getPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER);
    }

    public static void setLexicalHandler(@Nullable LexicalHandler lexicalHandler) {
        SAXReaderDefaultSettings.setPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER, lexicalHandler);
    }

    @Nullable
    public static DeclHandler getDeclarationHandler() {
        return (DeclHandler)SAXReaderDefaultSettings.getPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER);
    }

    public static void setDeclarationHandler(@Nullable DeclHandler declHandler) {
        SAXReaderDefaultSettings.setPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER, declHandler);
    }

    public static boolean hasAnyProperties() {
        return s_aRWLock.readLocked(() -> !s_aDefaultProperties.isEmpty());
    }

    @Nullable
    public static Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return null;
        }
        return s_aRWLock.readLocked(() -> s_aDefaultProperties.get((Object)eXMLParserProperty));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserProperty, Object> getAllPropertyValues() {
        return (ICommonsMap)s_aRWLock.readLocked(() -> (ICommonsMap)s_aDefaultProperties.getClone());
    }

    public static void setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserProperty), (String)"Property");
        s_aRWLock.writeLocked(() -> {
            if (object != null) {
                s_aDefaultProperties.put((Object)eXMLParserProperty, object);
            } else {
                s_aDefaultProperties.remove((Object)eXMLParserProperty);
            }
        });
    }

    public static void setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null && !map.isEmpty()) {
            s_aRWLock.writeLocked(() -> s_aDefaultProperties.putAll(map));
        }
    }

    @Nonnull
    public static EChange removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)s_aRWLock.writeLocked(() -> s_aDefaultProperties.removeObject((Object)eXMLParserProperty));
    }

    @Nonnull
    public static EChange removeAllPropertyValues() {
        return (EChange)s_aRWLock.writeLocked(() -> {
            if (s_aDefaultProperties.isEmpty()) {
                return EChange.UNCHANGED;
            }
            s_aDefaultProperties.clear();
            return EChange.CHANGED;
        });
    }

    public static boolean hasAnyFeature() {
        return s_aRWLock.readLocked(() -> !s_aDefaultFeatures.isEmpty());
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return null;
        }
        return (Boolean)s_aRWLock.readLocked(() -> (Boolean)s_aDefaultFeatures.get((Object)eXMLParserFeature));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return (ICommonsMap)s_aRWLock.readLocked(() -> (ICommonsMap)s_aDefaultFeatures.getClone());
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        s_aRWLock.writeLocked(() -> {
            Boolean cfr_ignored_0 = (Boolean)s_aDefaultFeatures.put((Object)eXMLParserFeature, (Object)bl);
        });
    }

    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        s_aRWLock.writeLocked(() -> {
            if (bl == null) {
                s_aDefaultFeatures.remove((Object)eXMLParserFeature);
            } else {
                s_aDefaultFeatures.put((Object)eXMLParserFeature, (Object)bl);
            }
        });
    }

    public static void setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null && !map.isEmpty()) {
            s_aRWLock.writeLocked(() -> s_aDefaultFeatures.putAll(map));
        }
    }

    @Nonnull
    public static EChange removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)s_aRWLock.writeLocked(() -> s_aDefaultFeatures.removeObject((Object)eXMLParserFeature));
    }

    @Nonnull
    public static EChange removeAllFeatures() {
        return (EChange)s_aRWLock.writeLocked(() -> {
            if (s_aDefaultFeatures.isEmpty()) {
                return EChange.UNCHANGED;
            }
            s_aDefaultFeatures.clear();
            return EChange.CHANGED;
        });
    }

    public static boolean requiresNewXMLParser() {
        return s_aRWLock.readLocked(() -> {
            if (s_bDefaultRequiresNewXMLParserExplicitly) {
                return true;
            }
            if (!s_aDefaultProperties.isEmpty() || !s_aDefaultFeatures.isEmpty()) {
                return true;
            }
            return s_aDefaultEntityResolver != null;
        });
    }

    @Nonnull
    public static IExceptionCallback<Throwable> getExceptionHandler() {
        return (IExceptionCallback)s_aRWLock.readLocked(() -> s_aDefaultExceptionHandler);
    }

    public static void setExceptionHandler(@Nonnull IExceptionCallback<Throwable> iExceptionCallback) {
        ValueEnforcer.notNull(iExceptionCallback, (String)"ExceptionHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultExceptionHandler = iExceptionCallback;
            return s_aDefaultExceptionHandler;
        });
    }

    public static boolean isRequiresNewXMLParserExplicitly() {
        return s_aRWLock.readLocked(() -> s_bDefaultRequiresNewXMLParserExplicitly);
    }

    public static void setRequiresNewXMLParserExplicitly(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bDefaultRequiresNewXMLParserExplicitly = bl;
            return s_bDefaultRequiresNewXMLParserExplicitly;
        });
    }

    static {
        s_aDefaultErrorHandler = new LoggingSAXErrorHandler();
        s_aDefaultProperties = new CommonsEnumMap(EXMLParserProperty.class);
        s_aDefaultFeatures = new CommonsEnumMap(EXMLParserFeature.class);
        s_aDefaultExceptionHandler = new XMLLoggingExceptionCallback();
        s_bDefaultRequiresNewXMLParserExplicitly = false;
        s_aInstance = new SAXReaderDefaultSettings();
    }
}

