/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.exception.InitializationException;
import com.helger.commons.factory.IFactory;
import com.helger.xml.serialize.read.XMLReaderFactoryCommons;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXReaderFactory
implements IFactory<XMLReader> {
    @Nonnull
    public XMLReader get() {
        return SAXReaderFactory.createXMLReader();
    }

    @Nonnull
    public static XMLReader createXMLReader() {
        try {
            XMLReader xMLReader = XMLReaderFactoryCommons.createXMLReader();
            return xMLReader;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InitializationException("Failed to instantiate XML reader!", (Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new InitializationException("Failed to instantiate XML reader!", (Throwable)sAXException);
        }
    }
}

