/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.schema;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.xml.sax.CollectingSAXErrorHandler;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.transform.TransformSourceFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

@Immutable
public final class XMLSchemaValidationHelper {
    private static final XMLSchemaValidationHelper s_aInstance = new XMLSchemaValidationHelper();

    private XMLSchemaValidationHelper() {
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull IReadableResource iReadableResource, @Nonnull IReadableResource iReadableResource2) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{iReadableResource}, iReadableResource2);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource[] iReadableResourceArray, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XML");
        return XMLSchemaValidationHelper.validate(iReadableResourceArray, (Source)TransformSourceFactory.create(iReadableResource));
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull Schema schema, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XML");
        return XMLSchemaValidationHelper.validate(schema, (Source)TransformSourceFactory.create(iReadableResource));
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource iReadableResource, @Nonnull Source source) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{iReadableResource}, source);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull @Nonempty IReadableResource[] iReadableResourceArray, @Nonnull Source source) {
        return XMLSchemaValidationHelper.validate(XMLSchemaCache.getInstance().getSchema(iReadableResourceArray), source);
    }

    @Nonnull
    public static IResourceErrorGroup validate(@Nonnull Schema schema, @Nonnull Source source) {
        ValueEnforcer.notNull((Object)schema, (String)"Schema");
        ValueEnforcer.notNull((Object)source, (String)"XML");
        Validator validator = schema.newValidator();
        CollectingSAXErrorHandler collectingSAXErrorHandler = new CollectingSAXErrorHandler();
        validator.setErrorHandler(collectingSAXErrorHandler);
        try {
            validator.validate(source, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to validate the XML " + source + " against " + schema, exception);
        }
        return collectingSAXErrorHandler.getResourceErrors();
    }
}

