/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl21.codelist;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasDisplayName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@CodingStyleguideUnaware
public enum EFullnessIndicationCode21 implements IHasID<String>,
IHasDisplayName
{
    _1("1", "More than one quarter volume available", "Indicates that there is more than a quarter of the volume available."),
    _2("2", "More than half volume available", "Indicates that there is more than a half of the volume available."),
    _3("3", "More than three quarters volume available", "Indicates that there is more than three quarters of the volume available."),
    _4("4", "Empty", "Indicates that the object is empty."),
    _5("5", "Full", "Indicates that the object is full."),
    _6("6", "No volume available", "Indicates that there is no space available in the object."),
    _7("7", "Full, mixed consignment", "Indicates that the equipment is fully loaded, and includes a number LCL (Less Than Container Load) consignments."),
    _8("8", "Full, single consignment", "Indicates that the container is fully loaded with a single FCL (Full Container Load) consignment."),
    _9("9", "Part load", "Container represents part of a consignment declared on a single Customs declaration (i.e. the Customs declaration covers more than one container)."),
    _10("10", "Part load mixed consignments", "Container represents part of the consignment declared on a single Customs declaration with the remainder being in other containers. Other goods, related to other declarations, are also in the container."),
    _11("11", "Single invoiced load", "Merchandise within a container/package covered by a single invoice."),
    _12("12", "Multi invoiced load", "Merchandise within a container/package covered by more than one invoice."),
    _13("13", "Full load, multiple bills", "A container representing a consignment of goods for one consignee with multiple bill of lading numbers.");

    private final String m_sID;
    private final String m_sDisplayName;
    private final String m_sDescription;

    private EFullnessIndicationCode21(@Nullable String string2, String string3, String string4) {
        this.m_sID = string2;
        this.m_sDisplayName = string3;
        this.m_sDescription = string4;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    @Nullable
    public static EFullnessIndicationCode21 getFromIDOrNull(@Nullable String string) {
        return (EFullnessIndicationCode21)EnumHelper.getFromIDOrNull(EFullnessIndicationCode21.class, (Object)string);
    }

    @Nullable
    public static String getDisplayNameFromIDOrNull(@Nullable String string) {
        EFullnessIndicationCode21 eFullnessIndicationCode21 = EFullnessIndicationCode21.getFromIDOrNull(string);
        return eFullnessIndicationCode21 == null ? null : eFullnessIndicationCode21.getDisplayName();
    }
}

