/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import com.helger.schematron.xslt.SchematronProviderXSLTFromSCH;
import com.helger.xml.serialize.write.XMLWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@ThreadSafe
public final class SchematronResourceSCHCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronResourceSCHCache.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, SchematronProviderXSLTFromSCH> CACHE = new CommonsHashMap();

    private SchematronResourceSCHCache() {
    }

    @Nullable
    public static SchematronProviderXSLTFromSCH createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compiling Schematron instance " + iReadableResource.toString());
        }
        if (!(schematronProviderXSLTFromSCH = new SchematronProviderXSLTFromSCH(iReadableResource, sCHTransformerCustomizer)).isValidSchematron()) {
            LOGGER.warn("The Schematron resource '" + iReadableResource.getResourceID() + "' is invalid!");
            if (LOGGER.isDebugEnabled() && schematronProviderXSLTFromSCH.getXSLTDocument() != null) {
                LOGGER.debug("  Created XSLT document:\n" + XMLWriter.getNodeAsString((Node)schematronProviderXSLTFromSCH.getXSLTDocument()));
            }
            return null;
        }
        if (schematronProviderXSLTFromSCH.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from Schematron resource '" + iReadableResource.getResourceID() + "'!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished compiling Schematron instance " + iReadableResource.toString());
        }
        return schematronProviderXSLTFromSCH;
    }

    @Nullable
    public static SchematronProviderXSLTFromSCH getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)sCHTransformerCustomizer, (String)"TransformerCustomizer");
        if (!iReadableResource.exists()) {
            LOGGER.warn("Schematron resource " + iReadableResource + " does not exist!");
            return null;
        }
        if (!sCHTransformerCustomizer.canCacheResult()) {
            return SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, sCHTransformerCustomizer);
        }
        String string = StringHelper.getImploded((char)':', (Object[])new String[]{iReadableResource.getResourceID(), StringHelper.getNotNull((String)sCHTransformerCustomizer.getPhase()), StringHelper.getNotNull((String)sCHTransformerCustomizer.getLanguageCode())});
        SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH = (SchematronProviderXSLTFromSCH)RW_LOCK.readLockedGet(() -> (SchematronProviderXSLTFromSCH)CACHE.get((Object)string));
        if (schematronProviderXSLTFromSCH != null) {
            return schematronProviderXSLTFromSCH;
        }
        return (SchematronProviderXSLTFromSCH)RW_LOCK.writeLockedGet(() -> {
            SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH = (SchematronProviderXSLTFromSCH)CACHE.get((Object)string);
            if (schematronProviderXSLTFromSCH == null && (schematronProviderXSLTFromSCH = SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, sCHTransformerCustomizer)) != null) {
                CACHE.put((Object)string, (Object)schematronProviderXSLTFromSCH);
            }
            return schematronProviderXSLTFromSCH;
        });
    }

    public static void clearCache() {
        RW_LOCK.writeLocked(() -> CACHE.clear());
    }
}

