/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.svrl.SVRLResourceError;
import com.helger.schematron.svrl.jaxb.DiagnosticReference;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractSVRLMessage
implements Serializable {
    protected ICommonsList<DiagnosticReference> m_aDiagnosticReferences;
    protected String m_sText;
    protected String m_sLocation;
    protected String m_sTest;
    protected String m_sRole;
    protected IErrorLevel m_aFlag;

    public AbstractSVRLMessage(@Nullable List<DiagnosticReference> list, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable IErrorLevel iErrorLevel) {
        this.m_aDiagnosticReferences = new CommonsArrayList(list);
        this.m_sText = StringHelper.trim((String)string);
        this.m_sLocation = string2;
        this.m_sTest = string3;
        this.m_sRole = string4;
        this.m_aFlag = iErrorLevel;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DiagnosticReference> getDiagnisticReferences() {
        return (ICommonsList)this.m_aDiagnosticReferences.getClone();
    }

    @Nullable
    public String getText() {
        return this.m_sText;
    }

    @Nullable
    public String getLocation() {
        return this.m_sLocation;
    }

    @Nullable
    public String getTest() {
        return this.m_sTest;
    }

    @Nullable
    public String getRole() {
        return this.m_sRole;
    }

    @Nonnull
    public IErrorLevel getFlag() {
        return this.m_aFlag;
    }

    @Nonnull
    public SVRLResourceError getAsResourceError(@Nullable String string) {
        return ((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)new SVRLResourceError.SVRLErrorBuilder(this.m_sTest).setErrorLevel(this.m_aFlag)).setErrorFieldName(this.m_sLocation)).setErrorLocation((ILocation)new SimpleLocation(string))).setErrorText(this.m_sText)).build();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("diagnosticRefs", this.m_aDiagnosticReferences).append("text", (Object)this.m_sText).append("location", (Object)this.m_sLocation).append("test", (Object)this.m_sTest).appendIfNotNull("role", (Object)this.m_sRole).append("flag", (Object)this.m_aFlag).getToString();
    }
}

