/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDiagnostics
implements IPSElement,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasIncludes {
    private final ICommonsList<Object> m_aContent = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(object -> object instanceof IMicroElement);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull((Object)pSInclude, (String)"Include");
        this.m_aContent.add((Object)pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aContent.containsAny(object -> object instanceof PSInclude);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return this.m_aContent.getAllInstanceOf(PSInclude.class);
    }

    public void addDiagnostic(@Nonnull PSDiagnostic pSDiagnostic) {
        ValueEnforcer.notNull((Object)pSDiagnostic, (String)"Diagnostic");
        this.m_aContent.add((Object)pSDiagnostic);
    }

    @Nullable
    public PSDiagnostic getDiagnosticOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (Object e : this.m_aContent) {
                PSDiagnostic pSDiagnostic;
                if (!(e instanceof PSDiagnostic) || !string.equals((pSDiagnostic = (PSDiagnostic)e).getID())) continue;
                return pSDiagnostic;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSDiagnostic> getAllDiagnostics() {
        return this.m_aContent.getAllInstanceOf(PSDiagnostic.class);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "diagnostics");
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild((IMicroNode)((IMicroElement)object).getClone());
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

