/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.cache.Cache;
import com.helger.commons.functional.IFunction;
import com.helger.schematron.SchematronException;
import com.helger.schematron.pure.bound.IPSBoundSchema;
import com.helger.schematron.pure.bound.PSBoundSchemaCacheKey;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class PSBoundSchemaCache
extends Cache<PSBoundSchemaCacheKey, IPSBoundSchema> {
    private PSBoundSchemaCache() {
        this(PSBoundSchemaCache.class.getName());
    }

    public PSBoundSchemaCache(@Nonnull String string) {
        super((IFunction & Serializable)pSBoundSchemaCacheKey -> {
            ValueEnforcer.notNull((Object)pSBoundSchemaCacheKey, (String)"Key");
            try {
                return pSBoundSchemaCacheKey.createBoundSchema();
            }
            catch (SchematronException schematronException) {
                throw new IllegalArgumentException(schematronException);
            }
        }, -1, string);
    }

    @Nonnull
    public static PSBoundSchemaCache getInstance() {
        return SingletonHolder.s_aInstance;
    }

    private static final class SingletonHolder {
        static final PSBoundSchemaCache s_aInstance = new PSBoundSchemaCache();

        private SingletonHolder() {
        }
    }
}

