/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.state.EValidity;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.schematron.AbstractSchematronResource;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.ISchematronXSLTBasedResource;
import com.helger.schematron.xslt.validator.ISchematronXSLTValidator;
import com.helger.schematron.xslt.validator.SchematronXSLTValidatorDefault;
import com.helger.xml.XMLFactory;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.transform.DefaultTransformURIResolver;
import com.helger.xml.transform.LoggingTransformErrorListener;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.s9api.XdmNode;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

@NotThreadSafe
public abstract class AbstractSchematronXSLTBasedResource<IMPLTYPE extends AbstractSchematronXSLTBasedResource<IMPLTYPE>>
extends AbstractSchematronResource
implements ISchematronXSLTBasedResource,
IGenericImplTrait<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchematronXSLTBasedResource.class);
    protected ErrorListener m_aCustomErrorListener;
    protected URIResolver m_aCustomURIResolver = new DefaultTransformURIResolver();
    protected final ICommonsOrderedMap<String, Object> m_aCustomParameters = new CommonsLinkedHashMap();
    private ISchematronXSLTValidator m_aXSLTValidator = new SchematronXSLTValidatorDefault();

    public AbstractSchematronXSLTBasedResource(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
        URL uRL = iReadableResource.getAsURL();
        this.setURIResolver((URIResolver)new DefaultTransformURIResolver().setDefaultBase(uRL != null ? uRL.toExternalForm() : null));
    }

    @Override
    @Nullable
    public ErrorListener getErrorListener() {
        return this.m_aCustomErrorListener;
    }

    @Nonnull
    public final IMPLTYPE setErrorListener(@Nullable ErrorListener errorListener) {
        this.m_aCustomErrorListener = errorListener;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Override
    @Nullable
    public URIResolver getURIResolver() {
        return this.m_aCustomURIResolver;
    }

    @Nonnull
    public final IMPLTYPE setURIResolver(@Nullable URIResolver uRIResolver) {
        this.m_aCustomURIResolver = uRIResolver;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedMap<String, Object> parameters() {
        return this.m_aCustomParameters;
    }

    @Deprecated
    public boolean hasParameters() {
        return this.m_aCustomParameters.isNotEmpty();
    }

    @Nonnull
    @Deprecated
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, Object> getParameters() {
        return this.m_aCustomParameters.getClone();
    }

    @Nonnull
    @Deprecated
    public IMPLTYPE setParameters(@Nullable Map<String, ?> map) {
        this.m_aCustomParameters.setAll(map);
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE setEntityResolver(@Nullable EntityResolver entityResolver) {
        this.internalSetEntityResolver(entityResolver);
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Nullable
    public abstract ISchematronXSLTBasedProvider getXSLTProvider();

    @Override
    @Nonnull
    public ISchematronXSLTValidator getXSLTValidator() {
        return this.m_aXSLTValidator;
    }

    @Nonnull
    public final IMPLTYPE setXSLTValidator(@Nonnull ISchematronXSLTValidator iSchematronXSLTValidator) {
        ValueEnforcer.notNull((Object)iSchematronXSLTValidator, (String)"XSLTValidator");
        this.m_aXSLTValidator = iSchematronXSLTValidator;
        return (IMPLTYPE)((AbstractSchematronXSLTBasedResource)this.thisAsT());
    }

    @Override
    public final boolean isValidSchematron() {
        ISchematronXSLTBasedProvider iSchematronXSLTBasedProvider = this.getXSLTProvider();
        return iSchematronXSLTBasedProvider != null && iSchematronXSLTBasedProvider.isValidSchematron();
    }

    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull Node node, @Nullable String string) throws Exception {
        ValueEnforcer.notNull((Object)node, (String)"XMLNode");
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(node, string);
        if (schematronOutputType == null) {
            return EValidity.INVALID;
        }
        return this.m_aXSLTValidator.getSchematronValidity(schematronOutputType);
    }

    @Override
    @Nullable
    public final Document applySchematronValidation(@Nonnull Node node, @Nullable String string) throws TransformerException {
        ValueEnforcer.notNull((Object)node, (String)"XMLNode");
        ISchematronXSLTBasedProvider iSchematronXSLTBasedProvider = this.getXSLTProvider();
        if (iSchematronXSLTBasedProvider == null || !iSchematronXSLTBasedProvider.isValidSchematron()) {
            return null;
        }
        if (SchematronDebug.isShowCreatedXSLT()) {
            LOGGER.info("Created XSLT document: " + XMLWriter.getNodeAsString((Node)iSchematronXSLTBasedProvider.getXSLTDocument()));
        }
        Document document = XMLFactory.newDocument();
        Transformer transformer = iSchematronXSLTBasedProvider.getXSLTTransformer();
        if (this.m_aCustomErrorListener != null) {
            transformer.setErrorListener(this.m_aCustomErrorListener);
        } else {
            transformer.setErrorListener((ErrorListener)new LoggingTransformErrorListener(Locale.US));
        }
        if (this.m_aCustomURIResolver != null) {
            transformer.setURIResolver(this.m_aCustomURIResolver);
        }
        if (this.m_aCustomParameters != null) {
            for (Map.Entry entry : this.m_aCustomParameters.entrySet()) {
                transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Applying Schematron XSLT on XML [start]");
        }
        DOMSource dOMSource = new DOMSource(node);
        dOMSource.setSystemId(string);
        transformer.transform(dOMSource, new DOMResult(document));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Applying Schematron XSLT on XML [end]");
        }
        if (SchematronDebug.isShowCreatedSVRL()) {
            LOGGER.info("Created SVRL:\n" + XMLWriter.getNodeAsString((Node)document));
        }
        return document;
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Node node, @Nullable String string) throws Exception {
        Document document = this.applySchematronValidation(node, string);
        if (document == null) {
            return null;
        }
        if (document.getDocumentElement() == null) {
            throw new IllegalStateException("Internal error: created SVRL DOM Document has no document node!");
        }
        return (SchematronOutputType)new SVRLMarshaller().read(document);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("XSLTValidator", (Object)this.m_aXSLTValidator).getToString();
    }

    private static /* synthetic */ void lambda$applySchematronValidation$0(XdmNode xdmNode, boolean bl, SourceLocator sourceLocator) {
        LOGGER.info("MessageListener: " + xdmNode + ", " + bl + ", " + sourceLocator);
    }
}

