/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.saxon;

import com.helger.commons.CGlobal;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.xml.transform.DefaultTransformURIResolver;
import com.helger.xml.transform.LoggingTransformErrorListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;

@Immutable
public final class SchematronTransformerFactory {
    public static final String SAXON_TRANSFORMER_FACTORY_CLASS = "net.sf.saxon.TransformerFactoryImpl";
    private static final TransformerFactory s_aDefaultFactory = SchematronTransformerFactory.createTransformerFactorySaxonFirst(null, (ErrorListener)new LoggingTransformErrorListener(CGlobal.DEFAULT_LOCALE), (URIResolver)new DefaultTransformURIResolver());

    private SchematronTransformerFactory() {
    }

    @Nonnull
    public static TransformerFactory getDefaultSaxonFirst() {
        return s_aDefaultFactory;
    }

    @Nonnull
    public static TransformerFactory createTransformerFactorySaxonFirst(@Nullable ClassLoader classLoader, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        TransformerFactory transformerFactory;
        try {
            ClassLoader classLoader2 = classLoader != null ? classLoader : ClassLoaderHelper.getContextClassLoader();
            transformerFactory = TransformerFactory.newInstance(SAXON_TRANSFORMER_FACTORY_CLASS, classLoader2);
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError throwable) {
            try {
                transformerFactory = TransformerFactory.newInstance();
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                throw new InitializationException("Failed to create XML TransformerFactory", (Throwable)transformerFactoryConfigurationError);
            }
        }
        if (errorListener != null) {
            transformerFactory.setErrorListener(errorListener);
        }
        if (uRIResolver != null) {
            transformerFactory.setURIResolver(uRIResolver);
        }
        return transformerFactory;
    }
}

