/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.AbstractPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCollectingPSErrorHandler
extends AbstractPSErrorHandler {
    private final ErrorList m_aErrorList;

    public AbstractCollectingPSErrorHandler(@Nonnull ErrorList errorList, @Nullable IPSErrorHandler iPSErrorHandler) {
        super(iPSErrorHandler);
        this.m_aErrorList = (ErrorList)ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
    }

    @Override
    protected void handle(@Nullable IReadableResource iReadableResource, @Nonnull IErrorLevel iErrorLevel, @Nullable IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        SingleError.SingleErrorBuilder singleErrorBuilder = (SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builder().setErrorLevel(iErrorLevel)).setErrorLocation((ILocation)(iReadableResource == null ? null : new SimpleLocation(iReadableResource.getResourceID())))).setErrorText(string)).setLinkedException(throwable);
        if (iPSElement != null) {
            String string2 = ClassHelper.getClassLocalName((Object)iPSElement);
            if (iPSElement instanceof IPSHasID && ((IPSHasID)((Object)iPSElement)).hasID()) {
                string2 = string2 + " [ID=" + ((IPSHasID)((Object)iPSElement)).getID() + "]";
            }
            singleErrorBuilder.setErrorFieldName(string2);
        }
        this.m_aErrorList.add((Object)singleErrorBuilder.build());
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getErrorList() {
        return this.m_aErrorList.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getAllFailures() {
        return this.m_aErrorList.getAllFailures();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getAllErrors() {
        return this.m_aErrorList.getAllErrors();
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return this.m_aErrorList.removeAll();
    }

    public boolean isEmpty() {
        return this.m_aErrorList.isEmpty();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("ErrorList", (Object)this.m_aErrorList).getToString();
    }
}

