/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.binding;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.exception.InitializationException;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.SchematronBindException;
import com.helger.schematron.pure.binding.xpath.PSXPathQueryBinding;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PSQueryBindingRegistry {
    public static final String QUERY_BINDING_XSLT = "xslt";
    public static final String QUERY_BINDING_XSLT2 = "xslt2";
    public static final IPSQueryBinding DEFAULT_QUERY_BINDING = PSXPathQueryBinding.getInstance();
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static final ICommonsMap<String, IPSQueryBinding> s_aMap = new CommonsHashMap();
    private static final PSQueryBindingRegistry s_aInstance;

    private PSQueryBindingRegistry() {
    }

    public static void registerQueryBinding(@Nonnull @Nonempty String string, @Nonnull IPSQueryBinding iPSQueryBinding) throws SchematronBindException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)iPSQueryBinding, (String)"QueryBinding");
        s_aRWLock.writeLockedThrowing((IThrowingRunnable & Serializable)() -> {
            if (s_aMap.containsKey((Object)string)) {
                throw new SchematronBindException("A queryBinding with the name '" + string + "' is already registered!");
            }
            s_aMap.put((Object)string, (Object)iPSQueryBinding);
        });
    }

    @Nullable
    public static IPSQueryBinding getQueryBindingOfName(@Nullable String string) {
        if (string == null) {
            return DEFAULT_QUERY_BINDING;
        }
        return (IPSQueryBinding)s_aRWLock.readLocked(() -> (IPSQueryBinding)s_aMap.get((Object)string));
    }

    @Nonnull
    public static IPSQueryBinding getQueryBindingOfNameOrThrow(@Nullable String string) throws SchematronBindException {
        IPSQueryBinding iPSQueryBinding = PSQueryBindingRegistry.getQueryBindingOfName(string);
        if (iPSQueryBinding == null) {
            throw new SchematronBindException("No query binding implementation present for query binding '" + string + "'");
        }
        return iPSQueryBinding;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, IPSQueryBinding> getAllRegisteredQueryBindings() {
        return (ICommonsMap)s_aRWLock.readLocked(() -> (ICommonsMap)s_aMap.getClone());
    }

    static {
        try {
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT2, DEFAULT_QUERY_BINDING);
        }
        catch (SchematronBindException schematronBindException) {
            throw new InitializationException((Throwable)schematronBindException);
        }
        s_aInstance = new PSQueryBindingRegistry();
    }
}

