/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xpath;

import com.helger.commons.lang.GenericReflection;
import com.helger.xml.XMLHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.w3c.dom.Node;

@Immutable
public final class XPathEvaluationHelper {
    private XPathEvaluationHelper() {
    }

    public static <T> T evaluate(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nonnull QName qName, @Nullable String string) throws XPathExpressionException {
        Node node2 = node;
        if (string != null && "net.sf.saxon.xpath.XPathExpressionImpl".equals(xPathExpression.getClass().getName())) {
            XPathExpressionImpl xPathExpressionImpl = (XPathExpressionImpl)xPathExpression;
            node2 = new DocumentWrapper((Node)XMLHelper.getOwnerDocument((Node)node), string, xPathExpressionImpl.getConfiguration()).wrap(node);
        }
        return (T)GenericReflection.uncheckedCast((Object)xPathExpression.evaluate(node2, qName));
    }
}

