/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.StringHelper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.SuccessfulReport;

@FunctionalInterface
public interface ISVRLErrorLevelDeterminator
extends Serializable {
    @Nonnull
    @Deprecated
    @DevelopersNote(value="Use getErrorLevelFromString instead")
    default public IErrorLevel getErrorLevelFromFlag(@Nullable String string) {
        return this.getErrorLevelFromString(string);
    }

    @Nonnull
    public IErrorLevel getErrorLevelFromString(@Nullable String var1);

    @Nonnull
    default public IErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        ValueEnforcer.notNull((Object)failedAssert, (String)"FailedAssert");
        String string = failedAssert.getFlag();
        if (StringHelper.hasNoText((String)string)) {
            string = failedAssert.getRole();
        }
        return this.getErrorLevelFromString(string);
    }

    @Nonnull
    default public IErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        ValueEnforcer.notNull((Object)successfulReport, (String)"SuccessfulReport");
        String string = successfulReport.getFlag();
        if (StringHelper.hasNoText((String)string)) {
            string = successfulReport.getRole();
        }
        return this.getErrorLevelFromString(successfulReport.getFlag());
    }
}

