/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDir;
import com.helger.schematron.pure.model.PSEmph;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSSpan;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDiagnostic
implements IPSClonableElement<PSDiagnostic>,
IPSOptionalElement,
IPSHasID,
IPSHasForeignElements,
IPSHasMixedContent,
IPSHasRichGroup {
    private String m_sID;
    private PSRichGroup m_aRich;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;
    private ICommonsList<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "<diagnostic> has no 'id'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
        if (StringHelper.hasNoText((String)this.m_sID)) {
            iPSErrorHandler.error(this, "<diagnostic> has no 'id'");
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new CommonsArrayList();
        }
        this.m_aForeignElements.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && this.m_aForeignElements.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return new CommonsArrayList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add((Object)string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.containsAny(object -> object instanceof String);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return this.m_aContent.getAllInstanceOf(String.class);
    }

    public void addValueOf(@Nonnull PSValueOf pSValueOf) {
        ValueEnforcer.notNull((Object)pSValueOf, (String)"ValueOf");
        this.m_aContent.add((Object)pSValueOf);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSValueOf> getAllValueOfs() {
        return this.m_aContent.getAllInstanceOf(PSValueOf.class);
    }

    public void addEmph(@Nonnull PSEmph pSEmph) {
        ValueEnforcer.notNull((Object)pSEmph, (String)"Emph");
        this.m_aContent.add((Object)pSEmph);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSEmph> getAllEmphs() {
        return this.m_aContent.getAllInstanceOf(PSEmph.class);
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull((Object)pSDir, (String)"Dir");
        this.m_aContent.add((Object)pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSDir> getAllDirs() {
        return this.m_aContent.getAllInstanceOf(PSDir.class);
    }

    public void addSpan(@Nonnull PSSpan pSSpan) {
        ValueEnforcer.notNull((Object)pSSpan, (String)"Span");
        this.m_aContent.add((Object)pSSpan);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSSpan> getAllSpans() {
        return this.m_aContent.getAllInstanceOf(PSSpan.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Object> getAllContentElements() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "diagnostic");
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aForeignElements != null) {
            for (Object object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                microElement.appendText((CharSequence)((String)object));
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSDiagnostic getClone() {
        PSDiagnostic pSDiagnostic = new PSDiagnostic();
        pSDiagnostic.setID(this.m_sID);
        pSDiagnostic.setRich(this.getRichClone());
        for (Object e : this.m_aContent) {
            if (e instanceof String) {
                pSDiagnostic.addText((String)e);
                continue;
            }
            if (e instanceof PSValueOf) {
                pSDiagnostic.addValueOf(((PSValueOf)e).getClone());
                continue;
            }
            if (e instanceof PSEmph) {
                pSDiagnostic.addEmph(((PSEmph)e).getClone());
                continue;
            }
            if (e instanceof PSDir) {
                pSDiagnostic.addDir(((PSDir)e).getClone());
                continue;
            }
            if (e instanceof PSSpan) {
                pSDiagnostic.addSpan(((PSSpan)e).getClone());
                continue;
            }
            throw new IllegalStateException("Unexpected content element: " + e);
        }
        if (this.hasForeignElements()) {
            pSDiagnostic.addForeignElements((Iterable)this.m_aForeignElements);
        }
        if (this.hasForeignAttributes()) {
            pSDiagnostic.addForeignAttributes((Map)this.m_aForeignAttrs);
        }
        return pSDiagnostic;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("rich", (Object)this.m_aRich).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).appendIf("foreignElements", this.m_aForeignElements, CollectionHelper::isNotEmpty).getToString();
    }
}

