/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.hierarchy.IHasChildren;
import com.helger.commons.hierarchy.visit.ChildrenProviderHierarchyVisitor;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.state.ESuccess;
import com.helger.commons.wrapper.Wrapper;
import com.helger.schematron.ISchematronResource;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.errorhandler.LoggingPSErrorHandler;
import com.helger.schematron.resolve.DefaultSchematronIncludeResolver;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Immutable
public final class SchematronHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronHelper.class);
    private static final SchematronHelper s_aInstance = new SchematronHelper();

    private SchematronHelper() {
    }

    @Nullable
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iSchematronResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XMLSource");
        try {
            return iSchematronResource.applySchematronValidationToSVRL((IHasInputStream)iReadableResource);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to apply Schematron " + (String)iSchematronResource.getID() + " onto XML resource " + iReadableResource.getResourceID(), exception);
        }
    }

    @Nullable
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull Source source) {
        ValueEnforcer.notNull((Object)iSchematronResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)source, (String)"XMLSource");
        try {
            return iSchematronResource.applySchematronValidationToSVRL(source);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to apply Schematron " + (String)iSchematronResource.getID() + " onto XML source " + source, exception);
        }
    }

    @Nullable
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull Node node) {
        ValueEnforcer.notNull((Object)iSchematronResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return SchematronHelper.applySchematron(iSchematronResource, new DOMSource(node));
    }

    @Nonnull
    public static IErrorList convertToErrorList(@Nonnull SchematronOutputType schematronOutputType, @Nullable String string) {
        ValueEnforcer.notNull((Object)schematronOutputType, (String)"SchematronOutput");
        ErrorList errorList = new ErrorList();
        for (SVRLFailedAssert sVRLFailedAssert : SVRLHelper.getAllFailedAssertions(schematronOutputType)) {
            errorList.add((Object)sVRLFailedAssert.getAsResourceError(string));
        }
        return errorList;
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static ESuccess _recursiveResolveAllSchematronIncludes(@Nonnull IMicroElement iMicroElement, @Nonnull IReadableResource iReadableResource, @Nullable ISAXReaderSettings iSAXReaderSettings, @Nonnull IPSErrorHandler iPSErrorHandler) {
        if (iMicroElement != null) {
            DefaultSchematronIncludeResolver defaultSchematronIncludeResolver = new DefaultSchematronIncludeResolver(iReadableResource);
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElementsRecursive()) {
                if (!"http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI()) || !iMicroElement2.getLocalName().equals("include")) continue;
                String string = iMicroElement2.getAttributeValue("href");
                try {
                    IMicroElement iMicroElement3;
                    IMicroDocument iMicroDocument;
                    IReadableResource iReadableResource2;
                    int n = string.indexOf(35);
                    String string2 = null;
                    if (n >= 0) {
                        string2 = string.substring(n + 1);
                        string = string.substring(0, n);
                    }
                    if ((iReadableResource2 = defaultSchematronIncludeResolver.getResolvedSchematronResource(string)) == null) {
                        iPSErrorHandler.error(iReadableResource, null, "Failed to resolve include '" + string + "'", null);
                        return ESuccess.FAILURE;
                    }
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("Resolved '" + string + "' relative to '" + defaultSchematronIncludeResolver.getBaseHref() + "' as '" + iReadableResource2.getPath() + "'");
                    }
                    if ((iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource2, (ISAXReaderSettings)iSAXReaderSettings)) == null) {
                        iPSErrorHandler.error(iReadableResource, null, "Failed to parse include " + iReadableResource2, null);
                        return ESuccess.FAILURE;
                    }
                    if (string2 == null) {
                        iMicroElement3 = iMicroDocument.getDocumentElement();
                    } else {
                        final String string3 = string2;
                        final Wrapper wrapper = new Wrapper();
                        ChildrenProviderHierarchyVisitor.visitFrom((IHasChildren)iMicroDocument.getDocumentElement(), (IHierarchyVisitorCallback)new DefaultHierarchyVisitorCallback<IMicroNode>(){

                            public EHierarchyVisitorReturn onItemBeforeChildren(IMicroNode iMicroNode) {
                                IMicroElement iMicroElement;
                                String string;
                                if (iMicroNode.isElement() && string3.equals(string = (iMicroElement = (IMicroElement)iMicroNode).getAttributeValue("id"))) {
                                    wrapper.set((Object)iMicroElement);
                                }
                                return EHierarchyVisitorReturn.CONTINUE;
                            }
                        }, (boolean)true);
                        iMicroElement3 = (IMicroElement)wrapper.get();
                        if (iMicroElement3 == null) {
                            iPSErrorHandler.warn(iReadableResource, null, "Failed to resolve an element with the ID '" + string2 + "' in " + iReadableResource2 + "! Therefore including the whole document!");
                            iMicroElement3 = iMicroDocument.getDocumentElement();
                        }
                    }
                    iMicroElement3.detachFromParent();
                    if (!"http://purl.oclc.org/dsdl/schematron".equals(iMicroElement3.getNamespaceURI())) {
                        iPSErrorHandler.error(iReadableResource, null, "The included resource " + iReadableResource2 + " contains the wrong XML namespace URI '" + iMicroElement3.getNamespaceURI() + "' but was expected to have '" + "http://purl.oclc.org/dsdl/schematron" + "'", null);
                        return ESuccess.FAILURE;
                    }
                    if ("schema".equals(iMicroElement3.getLocalName())) {
                        iPSErrorHandler.warn(iReadableResource, null, "The included resource " + iReadableResource2 + " seems to be a complete schema. To includes parts of a schema the respective element must be the root element of the included resource.");
                    }
                    if (SchematronHelper._recursiveResolveAllSchematronIncludes(iMicroElement3, iReadableResource2, iSAXReaderSettings, iPSErrorHandler).isFailure()) {
                        return ESuccess.FAILURE;
                    }
                    iMicroElement2.getParent().replaceChild((IMicroNode)iMicroElement2, (IMicroNode)iMicroElement3);
                }
                catch (IOException iOException) {
                    iPSErrorHandler.error(iReadableResource, null, "Failed to read include '" + string + "'", iOException);
                    return ESuccess.FAILURE;
                }
            }
        }
        return ESuccess.SUCCESS;
    }

    @Nullable
    public static IMicroDocument getWithResolvedSchematronIncludes(@Nonnull IReadableResource iReadableResource) {
        return SchematronHelper.getWithResolvedSchematronIncludes(iReadableResource, null, new LoggingPSErrorHandler());
    }

    @Nullable
    public static IMicroDocument getWithResolvedSchematronIncludes(@Nonnull IReadableResource iReadableResource, @Nullable ISAXReaderSettings iSAXReaderSettings, @Nonnull IPSErrorHandler iPSErrorHandler) {
        InputSource inputSource = InputSourceFactory.create((IReadableResource)iReadableResource);
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((InputSource)inputSource, (ISAXReaderSettings)iSAXReaderSettings);
        if (iMicroDocument != null && SchematronHelper._recursiveResolveAllSchematronIncludes(iMicroDocument.getDocumentElement(), iReadableResource, iSAXReaderSettings, iPSErrorHandler).isFailure()) {
            return null;
        }
        return iMicroDocument;
    }
}

