/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.saxon.SchematronTransformerFactory;
import com.helger.schematron.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.TransformSourceFactory;
import com.helger.xml.transform.XMLTransformerFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class SchematronProviderXSLTFromSCH
implements ISchematronXSLTBasedProvider {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronProviderXSLTFromSCH.class);
    public static final String SCHEMATRON_DIRECTORY_XSLT2 = "schematron/20100414-xslt2/";
    public static final String XSLT2_STEP1 = "schematron/20100414-xslt2/iso_dsdl_include.xsl";
    public static final String XSLT2_STEP2 = "schematron/20100414-xslt2/iso_abstract_expand.xsl";
    public static final String XSLT2_STEP3 = "schematron/20100414-xslt2/iso_svrl_for_xslt2.xsl";
    private static final AtomicBoolean s_bSaveIntermediateFiles = new AtomicBoolean(false);
    private static File s_aIntermediateMinifiedSCHFolder = new File("test-minified");
    private static File s_aIntermediateFinalXSLTFolder = new File("test-final");
    private static volatile Templates s_aStep1;
    private static volatile Templates s_aStep2;
    private static volatile Templates s_aStep3;
    private final IReadableResource m_aSchematronResource;
    private Document m_aSchematronXSLTDoc;
    private Templates m_aSchematronXSLTTemplates;

    public static final boolean isSaveIntermediateFiles() {
        return s_bSaveIntermediateFiles.get();
    }

    public static final void setSaveIntermediateFiles(boolean bl) {
        s_bSaveIntermediateFiles.set(bl);
    }

    @Nonnull
    public static final File getIntermediateMinifiedSCHFolder() {
        return s_aIntermediateMinifiedSCHFolder;
    }

    public static final void setIntermediateMinifiedSCHFolder(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"IntermediateMinifiedSCHFolder");
        s_aIntermediateMinifiedSCHFolder = file;
    }

    @Nonnull
    public static final File getIntermediateFinalXSLTFolder() {
        return s_aIntermediateFinalXSLTFolder;
    }

    public static final void setIntermediateFinalXSLTFolder(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"IntermediateFinalXSLTFolder");
        s_aIntermediateFinalXSLTFolder = file;
    }

    public static void cacheXSLTTemplates() {
        if (s_aStep1 == null) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Creating XSLT step 1 template");
            }
            s_aStep1 = XMLTransformerFactory.newTemplates((TransformerFactory)SchematronTransformerFactory.getDefaultSaxonFirst(), (IReadableResource)new ClassPathResource(XSLT2_STEP1));
        }
        if (s_aStep2 == null) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Creating XSLT step 2 template");
            }
            s_aStep2 = XMLTransformerFactory.newTemplates((TransformerFactory)SchematronTransformerFactory.getDefaultSaxonFirst(), (IReadableResource)new ClassPathResource(XSLT2_STEP2));
        }
        if (s_aStep3 == null) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Creating XSLT step 3 template");
            }
            s_aStep3 = XMLTransformerFactory.newTemplates((TransformerFactory)SchematronTransformerFactory.getDefaultSaxonFirst(), (IReadableResource)new ClassPathResource(XSLT2_STEP3));
        }
    }

    public SchematronProviderXSLTFromSCH(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        this.m_aSchematronResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)sCHTransformerCustomizer, (String)"TransformerCustomizer");
        try {
            Object object;
            SchematronProviderXSLTFromSCH.cacheXSLTTemplates();
            DOMResult dOMResult = new DOMResult();
            Transformer transformer = s_aStep1.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_1, transformer);
            transformer.transform((Source)TransformSourceFactory.create((IReadableResource)iReadableResource), dOMResult);
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Finished applying XSLT step 1 on " + iReadableResource);
            }
            DOMResult dOMResult2 = new DOMResult();
            Transformer transformer2 = s_aStep2.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_2, transformer2);
            transformer2.transform(TransformSourceFactory.create((Node)dOMResult.getNode()), dOMResult2);
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Finished applying XSLT step 2 on " + iReadableResource);
            }
            if (SchematronProviderXSLTFromSCH.isSaveIntermediateFiles()) {
                object = XMLWriter.getNodeAsString((Node)dOMResult2.getNode());
                SimpleFileIO.writeFile((File)new File(s_aIntermediateMinifiedSCHFolder, FilenameHelper.getWithoutPath((String)iReadableResource.getPath()) + ".min-xslt.sch"), (String)object, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ);
            }
            object = new DOMResult();
            Transformer transformer3 = s_aStep3.newTransformer();
            sCHTransformerCustomizer.customize(SCHTransformerCustomizer.EStep.SCH2XSLT_3, transformer3);
            transformer3.transform(TransformSourceFactory.create((Node)dOMResult2.getNode()), (Result)object);
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Finished applying XSLT step 3 on " + iReadableResource);
            }
            this.m_aSchematronXSLTDoc = (Document)((DOMResult)object).getNode();
            if (SchematronProviderXSLTFromSCH.isSaveIntermediateFiles()) {
                String string = XMLWriter.getNodeAsString((Node)this.m_aSchematronXSLTDoc);
                SimpleFileIO.writeFile((File)new File(s_aIntermediateFinalXSLTFolder, FilenameHelper.getWithoutPath((String)iReadableResource.getPath()) + ".xslt"), (String)string, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ);
            }
            this.m_aSchematronXSLTTemplates = XMLTransformerFactory.newTemplates((TransformerFactory)SchematronTransformerFactory.getDefaultSaxonFirst(), (Source)TransformSourceFactory.create((Node)this.m_aSchematronXSLTDoc));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Schematron preprocessor error", throwable);
        }
    }

    @Nonnull
    public IReadableResource getSchematronResource() {
        return this.m_aSchematronResource;
    }

    @Override
    public boolean isValidSchematron() {
        return this.m_aSchematronXSLTTemplates != null;
    }

    @Override
    @Nullable
    public Document getXSLTDocument() {
        return this.m_aSchematronXSLTDoc;
    }

    @Override
    @Nullable
    public Transformer getXSLTTransformer() throws TransformerConfigurationException {
        return this.m_aSchematronXSLTTemplates == null ? null : this.m_aSchematronXSLTTemplates.newTransformer();
    }
}

