/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.location.ErrorLocation;
import com.helger.commons.error.location.IErrorLocation;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.svrl.SVRLLocationBeautifierRegistry;
import com.helger.schematron.svrl.SVRLResourceError;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.oclc.purl.dsdl.svrl.DiagnosticReference;

public abstract class AbstractSVRLMessage {
    protected ICommonsList<DiagnosticReference> m_aDiagnosticReferences;
    protected String m_sText;
    protected String m_sLocation;
    protected String m_sTest;
    protected String m_sRole;
    protected IErrorLevel m_aFlag;

    @Nonnull
    protected static String getBeautifiedLocation(@Nonnull String string) {
        String string2 = string;
        Matcher matcher = RegExHelper.getMatcher((String)"\\Q*:\\E([a-zA-Z0-9_]+)\\Q[namespace-uri()='\\E([^']+)\\Q']\\E", (String)string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            String string5 = SVRLLocationBeautifierRegistry.getBeautifiedLocation(string4, string3);
            if (string5 == null) continue;
            string2 = StringHelper.replaceAll((String)string2, (String)matcher.group(), (CharSequence)string5);
        }
        return string2;
    }

    public AbstractSVRLMessage() {
    }

    public AbstractSVRLMessage(@Nullable List<DiagnosticReference> list, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable IErrorLevel iErrorLevel) {
        this.m_aDiagnosticReferences = new CommonsArrayList(list);
        this.m_sText = string;
        this.m_sLocation = string2;
        this.m_sTest = string3;
        this.m_sRole = string4;
        this.m_aFlag = iErrorLevel;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DiagnosticReference> getDiagnisticReferences() {
        return (ICommonsList)this.m_aDiagnosticReferences.getClone();
    }

    @Nullable
    public String getText() {
        return this.m_sText;
    }

    @Nullable
    public String getLocation() {
        return this.m_sLocation;
    }

    @Nullable
    public String getTest() {
        return this.m_sTest;
    }

    @Nullable
    public String getRole() {
        return this.m_sRole;
    }

    @Nonnull
    public IErrorLevel getFlag() {
        return this.m_aFlag;
    }

    @Nonnull
    public SVRLResourceError getAsResourceError(@Nullable String string) {
        return ((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)new SVRLResourceError.SVRLErrorBuilder(this.m_sTest).setErrorLevel(this.m_aFlag)).setErrorFieldName(this.m_sLocation)).setErrorLocation((IErrorLocation)new ErrorLocation(string))).setErrorText(this.m_sText)).build();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("diagnosticRefs", this.m_aDiagnosticReferences).append("text", (Object)this.m_sText).append("location", (Object)this.m_sLocation).append("test", (Object)this.m_sTest).appendIfNotNull("role", (Object)this.m_sRole).append("flag", (Object)this.m_aFlag).getToString();
    }
}

