/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.preprocess;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.CommonsTreeSet;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSortedSet;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class PreprocessorLookup {
    private final ICommonsMap<String, PSPattern> m_aPatterns = new CommonsHashMap();
    private final ICommonsMap<String, PSRule> m_aRules = new CommonsHashMap();

    public PreprocessorLookup(@Nonnull PSSchema pSSchema) {
        ValueEnforcer.notNull((Object)pSSchema, (String)"Schema");
        for (PSPattern pSPattern : pSSchema.getAllPatterns()) {
            if (pSPattern.isAbstract()) {
                this.m_aPatterns.put((Object)pSPattern.getID(), (Object)pSPattern);
            }
            for (PSRule pSRule : pSPattern.getAllRules()) {
                if (!pSRule.isAbstract()) continue;
                this.m_aRules.put((Object)pSRule.getID(), (Object)pSRule);
            }
        }
    }

    @Nullable
    public PSPattern getAbstractPatternOfID(@Nullable String string) {
        return (PSPattern)this.m_aPatterns.get((Object)string);
    }

    @Nullable
    public PSRule getAbstractRuleOfID(@Nullable String string) {
        return (PSRule)this.m_aRules.get((Object)string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSortedSet<String> getAllAbstractRuleIDs() {
        return new CommonsTreeSet((Collection)this.m_aRules.keySet());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("patterns", this.m_aPatterns).append("rules", this.m_aRules).getToString();
    }
}

