/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDir;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSTitle
implements IPSClonableElement<PSTitle>,
IPSOptionalElement,
IPSHasMixedContent {
    private final ICommonsList<Object> m_aContent = new CommonsArrayList();

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add((Object)string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.containsAny(object -> object instanceof String);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return this.m_aContent.getAllInstanceOf(String.class);
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull((Object)pSDir, (String)"Dir");
        this.m_aContent.add((Object)pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSDir> getAllDirs() {
        return this.m_aContent.getAllInstanceOf(PSDir.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Object> getAllContentElements() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "title");
        for (Object e : this.m_aContent) {
            if (e instanceof String) {
                microElement.appendText((CharSequence)((String)e));
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)e).getAsMicroElement());
        }
        return microElement;
    }

    @Nonnull
    public PSTitle getClone() {
        PSTitle pSTitle = new PSTitle();
        for (Object e : this.m_aContent) {
            if (e instanceof String) {
                pSTitle.addText((String)e);
                continue;
            }
            if (!(e instanceof PSDir)) continue;
            pSTitle.addDir(((PSDir)e).getClone());
        }
        return pSTitle;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).getToString();
    }
}

