/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDiagnostics
implements IPSElement,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasIncludes {
    private final ICommonsList<PSInclude> m_aIncludes = new CommonsArrayList();
    private final ICommonsList<PSDiagnostic> m_aDiagnostics = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;
    private ICommonsList<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (IPSElement iPSElement : this.m_aIncludes) {
            if (((PSInclude)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aDiagnostics) {
            if (((PSDiagnostic)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (IPSElement iPSElement : this.m_aIncludes) {
            ((PSInclude)iPSElement).validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aDiagnostics) {
            ((PSDiagnostic)iPSElement).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new CommonsArrayList();
        }
        this.m_aForeignElements.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && this.m_aForeignElements.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return new CommonsArrayList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull((Object)pSInclude, (String)"Include");
        this.m_aIncludes.add((Object)pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aIncludes.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return (ICommonsList)this.m_aIncludes.getClone();
    }

    public void addDiagnostic(@Nonnull PSDiagnostic pSDiagnostic) {
        ValueEnforcer.notNull((Object)pSDiagnostic, (String)"Diagnostic");
        this.m_aDiagnostics.add((Object)pSDiagnostic);
    }

    @Nullable
    public PSDiagnostic getDiagnosticOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (PSDiagnostic pSDiagnostic : this.m_aDiagnostics) {
                if (!string.equals(pSDiagnostic.getID())) continue;
                return pSDiagnostic;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSDiagnostic> getAllDiagnostics() {
        return (ICommonsList)this.m_aDiagnostics.getClone();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "diagnostics");
        if (this.m_aForeignElements != null) {
            for (Object object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (Object object : this.m_aIncludes) {
            microElement.appendChild((IMicroNode)((PSInclude)object).getAsMicroElement());
        }
        for (Object object : this.m_aDiagnostics) {
            microElement.appendChild((IMicroNode)((PSDiagnostic)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("includes", this.m_aIncludes, CollectionHelper::isNotEmpty).appendIf("diagnostics", this.m_aDiagnostics, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).appendIf("foreignElements", this.m_aForeignElements, CollectionHelper::isNotEmpty).getToString();
    }
}

