/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.SchematronBindException;
import com.helger.schematron.pure.binding.xpath.IPSXPathVariables;
import com.helger.schematron.pure.binding.xpath.PSXPathVariables;
import com.helger.schematron.pure.bound.AbstractPSBoundSchema;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundPattern;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundRule;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSName;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.validation.SchematronValidationException;
import com.helger.schematron.pure.validation.xpath.PSXPathValidationHandlerSVRL;
import com.helger.schematron.saxon.SaxonNamespaceContext;
import com.helger.schematron.xslt.util.PSErrorListener;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.xpath.XPathHelper;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.ErrorListener;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.xpath.XPathEvaluator;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public class PSXPathBoundSchema
extends AbstractPSBoundSchema {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PSXPathBoundSchema.class);
    private final XPathVariableResolver m_aXPathVariableResolver;
    private final XPathFunctionResolver m_aXPathFunctionResolver;
    private final XPathFactory m_aXPathFactory;
    private ICommonsList<PSXPathBoundPattern> m_aBoundPatterns;

    @Nullable
    private static XPathExpression _compileXPath(@Nonnull XPath xPath, @Nonnull String string) throws XPathExpressionException {
        XPathExpression xPathExpression = null;
        xPathExpression = xPath.compile(string);
        return xPathExpression;
    }

    @Nullable
    private ICommonsList<PSXPathBoundElement> _createBoundElements(@Nonnull IPSHasMixedContent iPSHasMixedContent, @Nonnull XPath xPath, @Nonnull IPSXPathVariables iPSXPathVariables) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = false;
        for (Object e : iPSHasMixedContent.getAllContentElements()) {
            XPathExpression xPathExpression;
            String string;
            IPSClonableElement<PSName> iPSClonableElement;
            if (e instanceof PSName) {
                iPSClonableElement = (PSName)e;
                if (((PSName)iPSClonableElement).hasPath()) {
                    string = iPSXPathVariables.getAppliedReplacement(((PSName)iPSClonableElement).getPath());
                    try {
                        xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                        commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement, string, xPathExpression));
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this.error(iPSClonableElement, "Failed to compile XPath expression in <name>: '" + string + "'", xPathExpressionException);
                        bl = true;
                    }
                    continue;
                }
                commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement));
                continue;
            }
            if (e instanceof PSValueOf) {
                iPSClonableElement = (PSValueOf)e;
                string = iPSXPathVariables.getAppliedReplacement(((PSValueOf)iPSClonableElement).getSelect());
                try {
                    xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                    commonsArrayList.add((Object)new PSXPathBoundElement(iPSClonableElement, string, xPathExpression));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(iPSClonableElement, "Failed to compile XPath expression in <value-of>: '" + string + "'", xPathExpressionException);
                    bl = true;
                }
                continue;
            }
            if (e instanceof String) {
                commonsArrayList.add((Object)new PSXPathBoundElement((String)e));
                continue;
            }
            commonsArrayList.add((Object)new PSXPathBoundElement((IPSElement)e));
        }
        if (bl) {
            return null;
        }
        return commonsArrayList;
    }

    @Nullable
    private ICommonsMap<String, PSXPathBoundDiagnostic> _createBoundDiagnostics(@Nonnull XPath xPath, @Nonnull IPSXPathVariables iPSXPathVariables) {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        boolean bl = false;
        PSSchema pSSchema = this.getOriginalSchema();
        if (pSSchema.hasDiagnostics()) {
            for (PSDiagnostic pSDiagnostic : pSSchema.getDiagnostics().getAllDiagnostics()) {
                ICommonsList<PSXPathBoundElement> iCommonsList = this._createBoundElements(pSDiagnostic, xPath, iPSXPathVariables);
                if (iCommonsList == null) {
                    bl = true;
                    continue;
                }
                PSXPathBoundDiagnostic pSXPathBoundDiagnostic = new PSXPathBoundDiagnostic(pSDiagnostic, iCommonsList);
                if (commonsHashMap.put((Object)pSDiagnostic.getID(), (Object)pSXPathBoundDiagnostic) == null) continue;
                this.error(pSDiagnostic, "A diagnostic element with ID '" + pSDiagnostic.getID() + "' was overwritten!");
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return commonsHashMap;
    }

    @Nullable
    private ICommonsList<PSXPathBoundPattern> _createBoundPatterns(@Nonnull XPath xPath, @Nonnull ICommonsMap<String, PSXPathBoundDiagnostic> iCommonsMap, @Nonnull IPSXPathVariables iPSXPathVariables) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = false;
        for (PSPattern pSPattern : this.getAllRelevantPatterns()) {
            Object object2;
            PSXPathVariables pSXPathVariables = (PSXPathVariables)iPSXPathVariables.getClone();
            if (pSPattern.hasAnyLet()) {
                for (Object object2 : pSPattern.getAllLetsAsMap().entrySet()) {
                    if (!pSXPathVariables.add((Map.Entry<String, String>)object2).isUnchanged()) continue;
                    this.error(pSPattern, "Duplicate <let> with name '" + (String)object2.getKey() + "' in <pattern>");
                }
            }
            CommonsArrayList commonsArrayList2 = new CommonsArrayList();
            for (PSRule pSRule : pSPattern.getAllRules()) {
                Object object3;
                Object object42;
                Object object52;
                PSXPathVariables pSXPathVariables2 = pSXPathVariables.getClone();
                if (pSRule.hasAnyLet()) {
                    for (Object object52 : pSRule.getAllLetsAsMap().entrySet()) {
                        if (!pSXPathVariables2.add((Map.Entry<String, String>)object52).isUnchanged()) continue;
                        this.error(pSRule, "Duplicate <let> with name '" + (String)object52.getKey() + "' in <rule>");
                    }
                }
                CommonsArrayList commonsArrayList3 = new CommonsArrayList();
                for (Object object42 : pSRule.getAllAssertReports()) {
                    object3 = pSXPathVariables2.getAppliedReplacement(((PSAssertReport)object42).getTest());
                    try {
                        XPathExpression xPathExpression = PSXPathBoundSchema._compileXPath(xPath, (String)object3);
                        ICommonsList<PSXPathBoundElement> iCommonsList = this._createBoundElements((IPSHasMixedContent)object42, xPath, pSXPathVariables2);
                        if (iCommonsList == null) {
                            bl = true;
                            continue;
                        }
                        PSXPathBoundAssertReport pSXPathBoundAssertReport = new PSXPathBoundAssertReport((PSAssertReport)object42, (String)object3, xPathExpression, iCommonsList, iCommonsMap);
                        commonsArrayList3.add((Object)pSXPathBoundAssertReport);
                    }
                    catch (Throwable throwable) {
                        this.error((IPSElement)object42, "Failed to compile XPath expression in <" + (((PSAssertReport)object42).isAssert() ? "assert" : "report") + ">: '" + (String)object3 + "' with the following variables: " + pSXPathVariables2.getAll(), throwable);
                        bl = true;
                    }
                }
                object52 = iPSXPathVariables.getAppliedReplacement(this.getValidationContext(pSRule.getContext()));
                object42 = null;
                try {
                    object3 = PSXPathBoundSchema._compileXPath(xPath, (String)object52);
                    object42 = new PSXPathBoundRule(pSRule, (String)object52, (XPathExpression)object3, (ICommonsList<PSXPathBoundAssertReport>)commonsArrayList3);
                    commonsArrayList2.add(object42);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to compile XPath expression in <rule>: '" + (String)object52 + "'", xPathExpressionException);
                    bl = true;
                }
            }
            object2 = new PSXPathBoundPattern(pSPattern, (ICommonsList<PSXPathBoundRule>)commonsArrayList2);
            commonsArrayList.add(object2);
        }
        if (bl) {
            return null;
        }
        return commonsArrayList;
    }

    @Nonnull
    public static XPathFactory createXPathFactorySaxonFirst() throws SchematronBindException {
        XPathFactory xPathFactory;
        try {
            xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "net.sf.saxon.xpath.XPathFactoryImpl", ClassLoaderHelper.getContextClassLoader());
        }
        catch (Throwable throwable) {
            try {
                xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            }
            catch (Exception exception) {
                throw new SchematronBindException("Failed to create JAXP XPathFactory", exception);
            }
        }
        return xPathFactory;
    }

    public PSXPathBoundSchema(@Nonnull IPSQueryBinding iPSQueryBinding, @Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver) throws SchematronBindException {
        super(iPSQueryBinding, pSSchema, string, iPSErrorHandler);
        this.m_aXPathVariableResolver = xPathVariableResolver;
        this.m_aXPathFunctionResolver = xPathFunctionResolver;
        this.m_aXPathFactory = PSXPathBoundSchema.createXPathFactorySaxonFirst();
    }

    @Nonnull
    private XPath _createXPathContext() {
        MapBasedNamespaceContext mapBasedNamespaceContext = this.getNamespaceContext();
        XPath xPath = XPathHelper.createNewXPath((XPathFactory)this.m_aXPathFactory, (XPathVariableResolver)this.m_aXPathVariableResolver, (XPathFunctionResolver)this.m_aXPathFunctionResolver, (NamespaceContext)mapBasedNamespaceContext);
        if (xPath instanceof XPathEvaluator) {
            XPathEvaluator xPathEvaluator = (XPathEvaluator)xPath;
            xPathEvaluator.setNamespaceContext((NamespaceContext)new SaxonNamespaceContext(mapBasedNamespaceContext));
            xPathEvaluator.getConfiguration().setErrorListener((ErrorListener)new PSErrorListener(this.getErrorHandler()));
        }
        return xPath;
    }

    @Nonnull
    public PSXPathBoundSchema bind() throws SchematronBindException {
        Object object;
        Iterator iterator;
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Binding pure Schematron");
        }
        if (this.m_aBoundPatterns != null) {
            throw new IllegalStateException("bind must only be called once!");
        }
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        PSXPathVariables pSXPathVariables = new PSXPathVariables();
        if (pSSchema.hasAnyLet()) {
            iterator = pSSchema.getAllLetsAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (!pSXPathVariables.add((Map.Entry<String, String>)object).isUnchanged()) continue;
                this.error(pSSchema, "Duplicate <let> with name '" + (String)object.getKey() + "' in global <schema>");
            }
        }
        if (pSPhase != null) {
            iterator = pSPhase.getAllLetsAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (!pSXPathVariables.add((Map.Entry<String, String>)object).isUnchanged()) continue;
                this.error(pSSchema, "Duplicate <let> with name '" + (String)object.getKey() + "' in <phase> with name '" + this.getPhaseID() + "'");
            }
        }
        if ((object = this._createBoundDiagnostics((XPath)((Object)(iterator = this._createXPathContext())), pSXPathVariables)) == null) {
            throw new SchematronBindException("Failed to precompile the diagnostics of the supplied schema. Check the " + (this.isDefaultErrorHandler() ? "log output" : "error listener") + " for XPath errors!");
        }
        this.m_aBoundPatterns = this._createBoundPatterns((XPath)((Object)iterator), (ICommonsMap<String, PSXPathBoundDiagnostic>)object, pSXPathVariables);
        if (this.m_aBoundPatterns == null) {
            throw new SchematronBindException("Failed to precompile the supplied schema.");
        }
        return this;
    }

    @Nullable
    public XPathVariableResolver getXPathVariableResolver() {
        return this.m_aXPathVariableResolver;
    }

    @Nullable
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.m_aXPathFunctionResolver;
    }

    @Override
    @Nonnull
    public String getValidationContext(@Nonnull String string) {
        if (string.startsWith("/")) {
            return string;
        }
        return "//" + string;
    }

    @Override
    public void validate(@Nonnull Node node, @Nonnull IPSValidationHandler iPSValidationHandler) throws SchematronValidationException {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)iPSValidationHandler, (String)"ValidationHandler");
        if (this.m_aBoundPatterns == null) {
            throw new IllegalStateException("bind was never called!");
        }
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        iPSValidationHandler.onStart(pSSchema, pSPhase);
        for (PSXPathBoundPattern pSXPathBoundPattern : this.m_aBoundPatterns) {
            PSPattern pSPattern = pSXPathBoundPattern.getPattern();
            iPSValidationHandler.onPattern(pSPattern);
            for (PSXPathBoundRule pSXPathBoundRule : pSXPathBoundPattern.getAllBoundRules()) {
                PSRule pSRule = pSXPathBoundRule.getRule();
                NodeList nodeList = null;
                try {
                    nodeList = (NodeList)pSXPathBoundRule.getBoundRuleExpression().evaluate(node, XPathConstants.NODESET);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to evaluate XPath expression to a nodeset: '" + pSXPathBoundRule.getRuleExpression() + "'", xPathExpressionException);
                    continue;
                }
                int n = nodeList.getLength();
                if (n <= 0) continue;
                for (PSXPathBoundAssertReport pSXPathBoundAssertReport : pSXPathBoundRule.getAllBoundAssertReports()) {
                    iPSValidationHandler.onRule(pSRule, pSXPathBoundRule.getRuleExpression());
                    PSAssertReport pSAssertReport = pSXPathBoundAssertReport.getAssertReport();
                    boolean bl = pSAssertReport.isAssert();
                    XPathExpression xPathExpression = pSXPathBoundAssertReport.getBoundTestExpression();
                    for (int i = 0; i < n; ++i) {
                        Node node2 = nodeList.item(i);
                        try {
                            boolean bl2 = (Boolean)xPathExpression.evaluate(node2, XPathConstants.BOOLEAN);
                            if (!(bl ? !bl2 && iPSValidationHandler.onFailedAssert(pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport).isBreak() : bl2 && iPSValidationHandler.onSuccessfulReport(pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport).isBreak())) continue;
                            return;
                        }
                        catch (XPathExpressionException xPathExpressionException) {
                            this.error(pSRule, "Failed to evaluate XPath expression to a boolean: '" + pSXPathBoundAssertReport.getTestExpression() + "'", xPathExpressionException);
                        }
                    }
                }
            }
        }
        iPSValidationHandler.onEnd(pSSchema, pSPhase);
    }

    @Override
    @Nonnull
    public SchematronOutputType validateComplete(@Nonnull Node node) throws SchematronValidationException {
        PSXPathValidationHandlerSVRL pSXPathValidationHandlerSVRL = new PSXPathValidationHandlerSVRL(this.getErrorHandler());
        this.validate(node, pSXPathValidationHandlerSVRL);
        return pSXPathValidationHandlerSVRL.getSVRL();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("boundPatterns", this.m_aBoundPatterns).getToString();
    }
}

