/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.helger.schematron.pure.model.PSRule;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class PSXPathBoundRule {
    private final PSRule m_aRule;
    private final String m_sRuleExpression;
    private final XPathExpression m_aBoundRuleExpression;
    private final ICommonsList<PSXPathBoundAssertReport> m_aBoundAssertReports;

    public PSXPathBoundRule(@Nonnull PSRule pSRule, @Nonnull String string, @Nonnull XPathExpression xPathExpression, @Nonnull ICommonsList<PSXPathBoundAssertReport> iCommonsList) {
        ValueEnforcer.notNull((Object)pSRule, (String)"Rule");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RuleExpression");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"BoundRuleExpression");
        ValueEnforcer.notNull(iCommonsList, (String)"BoundAssertReports");
        this.m_aRule = pSRule;
        this.m_sRuleExpression = string;
        this.m_aBoundRuleExpression = xPathExpression;
        this.m_aBoundAssertReports = iCommonsList;
    }

    @Nonnull
    public PSRule getRule() {
        return this.m_aRule;
    }

    @Nonnull
    public String getRuleExpression() {
        return this.m_sRuleExpression;
    }

    @Nonnull
    public XPathExpression getBoundRuleExpression() {
        return this.m_aBoundRuleExpression;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSXPathBoundAssertReport> getAllBoundAssertReports() {
        return (ICommonsList)this.m_aBoundAssertReports.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("rule", (Object)this.m_aRule).append("ruleExpression", (Object)this.m_sRuleExpression).append("boundRuleExpression", (Object)this.m_aBoundRuleExpression).append("boundAssertReports", this.m_aBoundAssertReports).getToString();
    }
}

