/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundRule;
import com.helger.schematron.pure.model.PSPattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PSXPathBoundPattern {
    private final PSPattern m_aPattern;
    private final ICommonsList<PSXPathBoundRule> m_aBoundRules;

    public PSXPathBoundPattern(@Nonnull PSPattern pSPattern, @Nonnull ICommonsList<PSXPathBoundRule> iCommonsList) {
        ValueEnforcer.notNull((Object)pSPattern, (String)"Pattern");
        ValueEnforcer.notNull(iCommonsList, (String)"BoundRules");
        this.m_aPattern = pSPattern;
        this.m_aBoundRules = iCommonsList;
    }

    @Nonnull
    public PSPattern getPattern() {
        return this.m_aPattern;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSXPathBoundRule> getAllBoundRules() {
        return (ICommonsList)this.m_aBoundRules.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("pattern", (Object)this.m_aPattern).append("boundRules", this.m_aBoundRules).getToString();
    }
}

