/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.model.PSAssertReport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class PSXPathBoundAssertReport {
    private final PSAssertReport m_aAssertReport;
    private final String m_sTestExpression;
    private final XPathExpression m_aBoundTestExpression;
    private final ICommonsList<PSXPathBoundElement> m_aBoundContent;
    private final ICommonsMap<String, PSXPathBoundDiagnostic> m_aBoundDiagnostics;

    public PSXPathBoundAssertReport(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull XPathExpression xPathExpression, @Nonnull ICommonsList<PSXPathBoundElement> iCommonsList, @Nonnull ICommonsMap<String, PSXPathBoundDiagnostic> iCommonsMap) {
        ValueEnforcer.notNull((Object)pSAssertReport, (String)"AssertReport");
        ValueEnforcer.notNull((Object)string, (String)"TestExpression");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"BoundTestExpression");
        ValueEnforcer.notNull(iCommonsList, (String)"BoundContent");
        ValueEnforcer.notNull(iCommonsMap, (String)"BoundDiagnostics");
        this.m_aAssertReport = pSAssertReport;
        this.m_sTestExpression = string;
        this.m_aBoundTestExpression = xPathExpression;
        this.m_aBoundContent = iCommonsList;
        this.m_aBoundDiagnostics = iCommonsMap;
    }

    @Nonnull
    public PSAssertReport getAssertReport() {
        return this.m_aAssertReport;
    }

    @Nonnull
    public String getTestExpression() {
        return this.m_sTestExpression;
    }

    @Nonnull
    public XPathExpression getBoundTestExpression() {
        return this.m_aBoundTestExpression;
    }

    @Nonnull
    public ICommonsList<PSXPathBoundElement> getAllBoundContentElements() {
        return (ICommonsList)this.m_aBoundContent.getClone();
    }

    @Nullable
    public PSXPathBoundDiagnostic getBoundDiagnosticOfID(@Nullable String string) {
        return (PSXPathBoundDiagnostic)this.m_aBoundDiagnostics.get((Object)string);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("assertReport", (Object)this.m_aAssertReport).append("testExpression", (Object)this.m_sTestExpression).append("boundTestExpression", (Object)this.m_aBoundTestExpression).append("boundContent", this.m_aBoundContent).append("boundDiagnostics", this.m_aBoundDiagnostics).getToString();
    }
}

