/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.SchematronException;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.PSQueryBindingRegistry;
import com.helger.schematron.pure.bound.IPSBoundSchema;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.exchange.PSReader;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.preprocess.PSPreprocessor;
import com.helger.schematron.pure.preprocess.SchematronPreprocessException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.xml.sax.EntityResolver;

@Immutable
public class PSBoundSchemaCacheKey {
    private final IReadableResource m_aResource;
    private final String m_sPhase;
    private final IPSErrorHandler m_aErrorHandler;
    private final XPathVariableResolver m_aVariableResolver;
    private final XPathFunctionResolver m_aFunctionResolver;
    private final EntityResolver m_aEntityResolver;
    private transient int m_nHashCode = 0;

    public PSBoundSchemaCacheKey(@Nonnull IReadableResource iReadableResource, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable EntityResolver entityResolver) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_aResource = iReadableResource;
        this.m_sPhase = string;
        this.m_aErrorHandler = iPSErrorHandler;
        this.m_aVariableResolver = xPathVariableResolver;
        this.m_aFunctionResolver = xPathFunctionResolver;
        this.m_aEntityResolver = entityResolver;
    }

    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nullable
    public final String getPhase() {
        return this.m_sPhase;
    }

    @Nullable
    public final IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nullable
    public final XPathVariableResolver getVariableResolver() {
        return this.m_aVariableResolver;
    }

    @Nullable
    public final XPathFunctionResolver getFunctionResolver() {
        return this.m_aFunctionResolver;
    }

    @Nullable
    public final EntityResolver getEntityResolver() {
        return this.m_aEntityResolver;
    }

    @Nonnull
    @OverrideOnDemand
    public PSSchema readSchema(@Nonnull IReadableResource iReadableResource, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable EntityResolver entityResolver) throws SchematronException {
        return new PSReader(iReadableResource, iPSErrorHandler, entityResolver).readSchema();
    }

    @Nonnull
    @OverrideOnDemand
    public IPSQueryBinding getQueryBinding(@Nonnull PSSchema pSSchema) throws SchematronException {
        return PSQueryBindingRegistry.getQueryBindingOfNameOrThrow(pSSchema.getQueryBinding());
    }

    @Nonnull
    @OverrideOnDemand
    public PSPreprocessor createPreprocessor(@Nonnull IPSQueryBinding iPSQueryBinding) {
        PSPreprocessor pSPreprocessor = PSPreprocessor.createPreprocessorWithoutInformationLoss(iPSQueryBinding);
        return pSPreprocessor;
    }

    @Nonnull
    @OverrideOnDemand
    public PSSchema createPreprocessedSchema(@Nonnull PSSchema pSSchema, @Nonnull IPSQueryBinding iPSQueryBinding) throws SchematronException {
        PSPreprocessor pSPreprocessor = this.createPreprocessor(iPSQueryBinding);
        PSSchema pSSchema2 = pSPreprocessor.getAsPreprocessedSchema(pSSchema);
        if (pSSchema2 == null) {
            throw new SchematronPreprocessException("Failed to preprocess schema " + pSSchema + " with query binding " + iPSQueryBinding);
        }
        return pSSchema2;
    }

    @Nonnull
    public IPSBoundSchema createBoundSchema() throws SchematronException {
        PSSchema pSSchema = this.readSchema(this.getResource(), this.getErrorHandler(), this.getEntityResolver());
        IPSQueryBinding iPSQueryBinding = this.getQueryBinding(pSSchema);
        PSSchema pSSchema2 = this.createPreprocessedSchema(pSSchema, iPSQueryBinding);
        return iPSQueryBinding.bind(pSSchema2, this.getPhase(), this.getErrorHandler(), this.getVariableResolver(), this.getFunctionResolver());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PSBoundSchemaCacheKey pSBoundSchemaCacheKey = (PSBoundSchemaCacheKey)object;
        return this.m_aResource.equals(pSBoundSchemaCacheKey.m_aResource) && EqualsHelper.equals((Object)this.m_sPhase, (Object)pSBoundSchemaCacheKey.m_sPhase) && EqualsHelper.equals((Object)this.m_aVariableResolver, (Object)pSBoundSchemaCacheKey.m_aVariableResolver) && EqualsHelper.equals((Object)this.m_aFunctionResolver, (Object)pSBoundSchemaCacheKey.m_aFunctionResolver);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_aResource).append((Object)this.m_sPhase).append((Object)this.m_aVariableResolver).append((Object)this.m_aFunctionResolver).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("resource", (Object)this.m_aResource).append("phase", (Object)this.m_sPhase).appendIfNotNull("errorHandler", (Object)this.m_aErrorHandler).appendIfNotNull("variableResolver", (Object)this.m_aVariableResolver).appendIfNotNull("functionResolver", (Object)this.m_aFunctionResolver).getToString();
    }
}

