/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.schema.IHasSchema;
import com.helger.xml.schema.XMLSchemaValidationHelper;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

@MustImplementEqualsAndHashcode
public interface IJAXBDocumentType
extends IHasSchema,
Serializable {
    @Nonnull
    public Class<?> getImplementationClass();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllXSDPaths();

    @Nonnull
    public String getNamespaceURI();

    @Nonnull
    @Nonempty
    public String getLocalName();

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<? extends IReadableResource> getAllXSDResources() {
        return new CommonsArrayList(this.getAllXSDPaths(), ClassPathResource::new);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<? extends IReadableResource> getAllXSDResources(@Nullable ClassLoader classLoader) {
        return new CommonsArrayList(this.getAllXSDPaths(), string -> new ClassPathResource(string, classLoader));
    }

    @Nullable
    public Schema getSchema(@Nullable ClassLoader var1);

    @Nullable
    default public Validator getValidator() {
        return this.getValidator(null, null);
    }

    @Nullable
    default public Validator getValidator(@Nullable ClassLoader classLoader) {
        return this.getValidator(classLoader, null);
    }

    @Nullable
    default public Validator getValidator(@Nullable ClassLoader classLoader, @Nullable Locale locale) {
        Validator validator;
        Schema schema = this.getSchema(classLoader);
        if (schema != null && (validator = schema.newValidator()) != null) {
            if (locale != null) {
                EXMLParserProperty.GENERAL_LOCALE.applyTo(validator, (Object)locale);
            }
            return validator;
        }
        return null;
    }

    @Nullable
    default public IErrorList validateXML(@Nonnull IReadableResource iReadableResource) {
        return this.validateXML(iReadableResource, null);
    }

    @Nullable
    default public IErrorList validateXML(@Nonnull IReadableResource iReadableResource, @Nullable ClassLoader classLoader) {
        Schema schema = this.getSchema(classLoader);
        return schema == null ? null : XMLSchemaValidationHelper.validate((Schema)schema, (IReadableResource)iReadableResource);
    }
}

