/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSPropertyEnumOrNumbers
extends CSSPropertyEnum {
    private final boolean m_bWithPercentage;
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyEnumOrNumbers(@NonNull ECSSProperty eCSSProperty, boolean bl, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, bl, n, n2, stringArray);
    }

    public CSSPropertyEnumOrNumbers(@NonNull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, bl, n, n2, stringArray);
    }

    public CSSPropertyEnumOrNumbers(@NonNull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, stringArray);
        ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)n2, (String)"MaxNumbers");
        if (n2 < n) {
            throw new IllegalArgumentException("MaxNumbers (" + n2 + ") must be >= MinNumbers (" + n + ")");
        }
        this.m_bWithPercentage = bl;
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    public CSSPropertyEnumOrNumbers(@NonNull ECSSProperty eCSSProperty, boolean bl, @Nonnegative int n, @Nonnegative int n2, @Nonempty @NonNull Iterable<String> iterable) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, bl, n, n2, iterable);
    }

    public CSSPropertyEnumOrNumbers(@NonNull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2, @Nonempty @NonNull Iterable<String> iterable) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, bl, n, n2, iterable);
    }

    public CSSPropertyEnumOrNumbers(@NonNull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2, @Nonempty @NonNull Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, iterable);
        ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)n2, (String)"MaxNumbers");
        if (n2 < n) {
            throw new IllegalArgumentException("MaxNumbers (" + n2 + ") must be >= MinNumbers (" + n + ")");
        }
        this.m_bWithPercentage = bl;
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinNumbers;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxNumbers;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
        if (stringArray.length < this.m_nMinNumbers || stringArray.length > this.m_nMaxNumbers) {
            return false;
        }
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (super.isValidValue(string3) || CSSNumberHelper.isValueWithUnit(string3, this.m_bWithPercentage)) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull CSSPropertyEnumOrNumbers getClone(@NonNull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnumOrNumbers(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers, (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    public @NonNull CSSPropertyEnumOrNumbers getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyEnumOrNumbers(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers, (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyEnumOrNumbers cSSPropertyEnumOrNumbers = (CSSPropertyEnumOrNumbers)object;
        return this.m_bWithPercentage == cSSPropertyEnumOrNumbers.m_bWithPercentage && this.m_nMinNumbers == cSSPropertyEnumOrNumbers.m_nMinNumbers && this.m_nMaxNumbers == cSSPropertyEnumOrNumbers.m_nMaxNumbers;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).append(this.m_nMinNumbers).append(this.m_nMaxNumbers).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).getToString();
    }
}

