/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSRGBA;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class CSSRGB
implements ICSSWriteable,
ICSSColor,
ICloneable<CSSRGB> {
    private String m_sRed;
    private String m_sGreen;
    private String m_sBlue;

    public CSSRGB(@NonNull CSSRGB cSSRGB) {
        this(cSSRGB.getRed(), cSSRGB.getGreen(), cSSRGB.getBlue());
    }

    public CSSRGB(int n, int n2, int n3) {
        this(Integer.toString(CSSColorHelper.getRGBValue(n)), Integer.toString(CSSColorHelper.getRGBValue(n2)), Integer.toString(CSSColorHelper.getRGBValue(n3)));
    }

    public CSSRGB(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3) {
        this.setRed(string);
        this.setGreen(string2);
        this.setBlue(string3);
    }

    @Nonempty
    public final @NonNull String getRed() {
        return this.m_sRed;
    }

    public final @NonNull CSSRGB setRed(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Red");
        this.m_sRed = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getGreen() {
        return this.m_sGreen;
    }

    public final @NonNull CSSRGB setGreen(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Green");
        this.m_sGreen = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getBlue() {
        return this.m_sBlue;
    }

    public final @NonNull CSSRGB setBlue(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Blue");
        this.m_sBlue = string;
        return this;
    }

    public @NonNull CSSRGBA getAsRGBA(float f) {
        return new CSSRGBA(this, f);
    }

    public @NonNull CSSRGBA getAsRGBA(@Nonempty @NonNull String string) {
        return new CSSRGBA(this, string);
    }

    @Override
    @Nonempty
    public @NonNull String getAsString() {
        return "rgb(" + this.m_sRed + "," + this.m_sGreen + "," + this.m_sBlue + ")";
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.getAsString();
    }

    public @NonNull CSSRGB getClone() {
        return new CSSRGB(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSRGB cSSRGB = (CSSRGB)object;
        return this.m_sRed.equals(cSSRGB.m_sRed) && this.m_sGreen.equals(cSSRGB.m_sGreen) && this.m_sBlue.equals(cSSRGB.m_sBlue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRed).append((Object)this.m_sGreen).append((Object)this.m_sBlue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("red", (Object)this.m_sRed).append("green", (Object)this.m_sGreen).append("blue", (Object)this.m_sBlue).getToString();
    }
}

