/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringReplace;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.ECSSExpressionOperator;
import com.helger.css.decl.ICSSExpressionMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSExpression
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSExpressionMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public @NonNull CSSExpression addMember(@NonNull ICSSExpressionMember iCSSExpressionMember) {
        ValueEnforcer.notNull((Object)iCSSExpressionMember, (String)"ExpressionMember");
        this.m_aMembers.add((Object)iCSSExpressionMember);
        return this;
    }

    public @NonNull CSSExpression addMember(@Nonnegative int n, @NonNull ICSSExpressionMember iCSSExpressionMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSExpressionMember, (String)"ExpressionMember");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add((Object)iCSSExpressionMember);
        } else {
            this.m_aMembers.add(n, (Object)iCSSExpressionMember);
        }
        return this;
    }

    public @NonNull CSSExpression addTermSimple(@Nonempty @NonNull String string) {
        return this.addMember(new CSSExpressionMemberTermSimple(string));
    }

    public @NonNull CSSExpression addTermSimple(@Nonnegative int n, @Nonempty @NonNull String string) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(string));
    }

    public @NonNull CSSExpression addNumber(int n) {
        return this.addMember(new CSSExpressionMemberTermSimple(n));
    }

    public @NonNull CSSExpression addNumber(@Nonnegative int n, int n2) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(n2));
    }

    public @NonNull CSSExpression addNumber(long l) {
        return this.addMember(new CSSExpressionMemberTermSimple(l));
    }

    public @NonNull CSSExpression addNumber(@Nonnegative int n, long l) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(l));
    }

    public @NonNull CSSExpression addNumber(float f) {
        return this.addMember(new CSSExpressionMemberTermSimple(f));
    }

    public @NonNull CSSExpression addNumber(@Nonnegative int n, float f) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(f));
    }

    public @NonNull CSSExpression addNumber(double d) {
        return this.addMember(new CSSExpressionMemberTermSimple(d));
    }

    public @NonNull CSSExpression addNumber(@Nonnegative int n, double d) {
        return this.addMember(n, new CSSExpressionMemberTermSimple(d));
    }

    @Nonempty
    public static @NonNull String getQuotedStringValue(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        if (string.length() == 0) {
            return "\"\"";
        }
        return "\"" + StringReplace.replaceAll((String)string, (String)"\"", (CharSequence)"\\\"") + "\"";
    }

    public @NonNull CSSExpression addString(@NonNull String string) {
        return this.addTermSimple(CSSExpression.getQuotedStringValue(string));
    }

    public @NonNull CSSExpression addString(@Nonnegative int n, @NonNull String string) {
        return this.addTermSimple(n, CSSExpression.getQuotedStringValue(string));
    }

    public @NonNull CSSExpression addURI(@Nonempty @NonNull String string) {
        return this.addMember(new CSSExpressionMemberTermURI(string));
    }

    public @NonNull CSSExpression addURI(@Nonnegative int n, @Nonempty @NonNull String string) {
        return this.addMember(n, new CSSExpressionMemberTermURI(string));
    }

    public @NonNull EChange removeMember(@Nullable ICSSExpressionMember iCSSExpressionMember) {
        return this.m_aMembers.removeObject((Object)iCSSExpressionMember);
    }

    public @NonNull EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    public @NonNull EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ICSSExpressionMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    public @Nullable ICSSExpressionMember getMemberAtIndex(@Nonnegative int n) {
        return (ICSSExpressionMember)this.m_aMembers.getAtIndex(n);
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    public @NonNull ICommonsList<CSSExpressionMemberTermSimple> getAllSimpleMembers() {
        return this.m_aMembers.getAllInstanceOf(CSSExpressionMemberTermSimple.class);
    }

    @Override
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ICSSExpressionMember iCSSExpressionMember : this.m_aMembers) {
            boolean bl2 = iCSSExpressionMember instanceof ECSSExpressionOperator;
            if (!bl2 && !bl && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(iCSSExpressionMember.getAsCSSString(iCSSWriterSettings, n));
            bl = bl2;
        }
        return stringBuilder.toString();
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpression cSSExpression = (CSSExpression)object;
        return this.m_aMembers.equals(cSSExpression.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }

    public static @NonNull CSSExpression createSimple(@Nonempty @NonNull String string) {
        return new CSSExpression().addTermSimple(string);
    }

    public static @NonNull CSSExpression createString(@Nonempty @NonNull String string) {
        return new CSSExpression().addString(string);
    }

    public static @NonNull CSSExpression createNumber(int n) {
        return new CSSExpression().addNumber(n);
    }

    public static @NonNull CSSExpression createNumber(long l) {
        return new CSSExpression().addNumber(l);
    }

    public static @NonNull CSSExpression createNumber(float f) {
        return new CSSExpression().addNumber(f);
    }

    public static @NonNull CSSExpression createNumber(double d) {
        return new CSSExpression().addNumber(d);
    }

    public static @NonNull CSSExpression createURI(@Nonempty @NonNull String string) {
        return new CSSExpression().addURI(string);
    }
}

