/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.writer;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriter;
import com.helger.css.writer.CSSWriterSettings;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSCompressor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSCompressor.class);
    private static final CSSCompressor INSTANCE = new CSSCompressor();

    private CSSCompressor() {
    }

    public static @NonNull String getCompressedCSS(@NonNull String string) {
        return CSSCompressor.getCompressedCSS(string, false);
    }

    public static @NonNull String getCompressedCSS(@NonNull String string, boolean bl) {
        CSSWriterSettings cSSWriterSettings = new CSSWriterSettings(true);
        cSSWriterSettings.setRemoveUnnecessaryCode(bl);
        return CSSCompressor.getRewrittenCSS(string, cSSWriterSettings);
    }

    public static @NonNull String getRewrittenCSS(@NonNull String string, @NonNull CSSWriterSettings cSSWriterSettings) {
        ValueEnforcer.notNull((Object)string, (String)"OriginalCSS");
        ValueEnforcer.notNull((Object)cSSWriterSettings, (String)"Settings");
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string);
        if (cascadingStyleSheet != null) {
            try {
                return new CSSWriter(cSSWriterSettings).getCSSAsString(cascadingStyleSheet);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to write optimized CSS!", (Throwable)exception);
            }
        }
        return string;
    }
}

