/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.RegEx;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringHex;
import com.helger.cache.regex.RegExHelper;
import com.helger.css.decl.CSSHSL;
import com.helger.css.decl.CSSHSLA;
import com.helger.css.decl.CSSRGB;
import com.helger.css.decl.CSSRGBA;
import com.helger.css.utils.ECSSColor;
import com.helger.css.utils.ECSSColorName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class CSSColorHelper {
    public static final int RGB_MIN = 0;
    public static final int RGB_MAX = 255;
    public static final int RGB_RANGE = 256;
    public static final int HSL_MIN = 0;
    public static final int HSL_MAX = 359;
    public static final int HSL_RANGE = 360;
    public static final int PERCENTAGE_MIN = 0;
    public static final int PERCENTAGE_MAX = 100;
    public static final float OPACITY_MIN = 0.0f;
    public static final float OPACITY_MAX = 1.0f;
    @RegEx
    private static final String PATTERN_PART_VALUE = "((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)";
    @RegEx
    private static final String PATTERN_PART_PERCENTAGE = "((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))";
    @RegEx
    private static final String PATTERN_PART_OPACITY = "([0-9]*\\.[0-9]*|[0-9]+)";
    @RegEx
    private static final String PATTERN_RGB = "^rgb\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*\\)$";
    @RegEx
    private static final String PATTERN_RGBA = "^rgba\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*([0-9]*\\.[0-9]*|[0-9]+)\\s*\\)$";
    @RegEx
    private static final String PATTERN_HSL = "^hsl\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*\\)$";
    @RegEx
    private static final String PATTERN_HSLA = "^hsla\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*([0-9]*\\.[0-9]*|[0-9]+)\\s*\\)$";
    @RegEx
    private static final String PATTERN_HEX = "^#([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$";
    private static final CSSColorHelper INSTANCE = new CSSColorHelper();

    private CSSColorHelper() {
    }

    public static boolean isColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.isEmpty((String)string2)) {
            return false;
        }
        return CSSColorHelper.isRGBColorValue(string2) || CSSColorHelper.isRGBAColorValue(string2) || CSSColorHelper.isHSLColorValue(string2) || CSSColorHelper.isHSLAColorValue(string2) || CSSColorHelper.isHexColorValue(string2) || ECSSColor.isDefaultColorName(string2) || ECSSColorName.isDefaultColorName(string2) || string2.equals("currentColor") || string2.equals("transparent");
    }

    public static boolean isRGBColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.isNotEmpty((String)string2) && string2.startsWith("rgb") && RegExHelper.stringMatchesPattern((String)PATTERN_RGB, (String)string2);
    }

    public static @Nullable CSSRGB getParsedRGBColorValue(@Nullable String string) {
        String[] stringArray;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.isNotEmpty((String)string2) && string2.startsWith("rgb") && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_RGB, (String)string2)) != null) {
            return new CSSRGB(stringArray[0], stringArray[1], stringArray[2]);
        }
        return null;
    }

    public static boolean isRGBAColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.isNotEmpty((String)string2) && string2.startsWith("rgba") && RegExHelper.stringMatchesPattern((String)PATTERN_RGBA, (String)string2);
    }

    public static @Nullable CSSRGBA getParsedRGBAColorValue(@Nullable String string) {
        String[] stringArray;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.isNotEmpty((String)string2) && string2.startsWith("rgba") && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_RGBA, (String)string2)) != null) {
            return new CSSRGBA(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
        return null;
    }

    public static boolean isHSLColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.isNotEmpty((String)string2) && string2.startsWith("hsl") && RegExHelper.stringMatchesPattern((String)PATTERN_HSL, (String)string2);
    }

    public static @Nullable CSSHSL getParsedHSLColorValue(@Nullable String string) {
        String[] stringArray;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.isNotEmpty((String)string2) && string2.startsWith("hsl") && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_HSL, (String)string2)) != null) {
            return new CSSHSL(stringArray[0], stringArray[1], stringArray[2]);
        }
        return null;
    }

    public static boolean isHSLAColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.isNotEmpty((String)string2) && string2.startsWith("hsla") && RegExHelper.stringMatchesPattern((String)PATTERN_HSLA, (String)string2);
    }

    public static @Nullable CSSHSLA getParsedHSLAColorValue(@Nullable String string) {
        String[] stringArray;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.isNotEmpty((String)string2) && string2.startsWith("hsla") && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_HSLA, (String)string2)) != null) {
            return new CSSHSLA(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
        return null;
    }

    public static boolean isHexColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.isNotEmpty((String)string2) && string2.charAt(0) == '#' && RegExHelper.stringMatchesPattern((String)PATTERN_HEX, (String)string2);
    }

    @Nonnegative
    private static int _mod(int n, int n2) {
        int n3;
        for (n3 = n; n3 < 0; n3 += n2) {
        }
        return n3 % n2;
    }

    @Nonnegative
    private static float _mod(float f, int n) {
        float f2;
        for (f2 = f; f2 < 0.0f; f2 += (float)n) {
        }
        return f2 % (float)n;
    }

    @Nonnegative
    public static int getRGBValue(int n) {
        return CSSColorHelper._mod(n, 256);
    }

    @Nonnegative
    public static float getOpacityToUse(float f) {
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }

    @Nonempty
    public static @NonNull String getRGBColorValue(int n, int n2, int n3) {
        return new StringBuilder(16).append("rgb(").append(CSSColorHelper.getRGBValue(n)).append(',').append(CSSColorHelper.getRGBValue(n2)).append(',').append(CSSColorHelper.getRGBValue(n3)).append(")").toString();
    }

    @Nonempty
    public static @NonNull String getRGBAColorValue(int n, int n2, int n3, float f) {
        return new StringBuilder(24).append("rgba(").append(CSSColorHelper.getRGBValue(n)).append(',').append(CSSColorHelper.getRGBValue(n2)).append(',').append(CSSColorHelper.getRGBValue(n3)).append(',').append(CSSColorHelper.getOpacityToUse(f)).append(")").toString();
    }

    @Nonnegative
    public static int getHSLHueValue(int n) {
        return CSSColorHelper._mod(n, 360);
    }

    @Nonnegative
    public static float getHSLHueValue(float f) {
        return CSSColorHelper._mod(f, 360);
    }

    @Nonnegative
    public static int getHSLPercentageValue(int n) {
        return n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    @Nonnegative
    public static float getHSLPercentageValue(float f) {
        return f < 0.0f ? 0.0f : (f > 100.0f ? 100.0f : f);
    }

    @Nonempty
    public static @NonNull String getHSLColorValue(int n, int n2, int n3) {
        return new StringBuilder(18).append("hsl(").append(CSSColorHelper.getHSLHueValue(n)).append(',').append(CSSColorHelper.getHSLPercentageValue(n2)).append("%,").append(CSSColorHelper.getHSLPercentageValue(n3)).append("%").append(")").toString();
    }

    @Nonempty
    public static @NonNull String getHSLColorValue(float f, float f2, float f3) {
        return new StringBuilder(18).append("hsl(").append(CSSColorHelper.getHSLHueValue(f)).append(',').append(CSSColorHelper.getHSLPercentageValue(f2)).append("%,").append(CSSColorHelper.getHSLPercentageValue(f3)).append("%").append(")").toString();
    }

    @Nonempty
    public static @NonNull String getHSLAColorValue(int n, int n2, int n3, float f) {
        return new StringBuilder(32).append("hsla(").append(CSSColorHelper.getHSLHueValue(n)).append(',').append(CSSColorHelper.getHSLPercentageValue(n2)).append("%,").append(CSSColorHelper.getHSLPercentageValue(n3)).append("%,").append(CSSColorHelper.getOpacityToUse(f)).append(")").toString();
    }

    @Nonempty
    public static @NonNull String getHSLAColorValue(float f, float f2, float f3, float f4) {
        return new StringBuilder(32).append("hsla(").append(CSSColorHelper.getHSLHueValue(f)).append(',').append(CSSColorHelper.getHSLPercentageValue(f2)).append("%,").append(CSSColorHelper.getHSLPercentageValue(f3)).append("%,").append(CSSColorHelper.getOpacityToUse(f4)).append(")").toString();
    }

    @Nonempty
    private static @NonNull String _getRGBPartAsHexString(int n) {
        return StringHex.getHexStringLeadingZero((int)CSSColorHelper.getRGBValue(n), (int)2);
    }

    @Nonempty
    public static @NonNull String getHexColorValue(int n, int n2, int n3) {
        return new StringBuilder(7).append('#').append(CSSColorHelper._getRGBPartAsHexString(n)).append(CSSColorHelper._getRGBPartAsHexString(n2)).append(CSSColorHelper._getRGBPartAsHexString(n3)).toString();
    }

    @Nonempty
    public static @NonNull float[] getRGBAsHSLValue(int n, int n2, int n3) {
        float f;
        int n4;
        int n5;
        int n6 = n5 = n > n2 ? n : n2;
        if (n3 > n5) {
            n5 = n3;
        }
        int n7 = n4 = n < n2 ? n : n2;
        if (n3 < n4) {
            n4 = n3;
        }
        float f2 = (float)n5 / 255.0f;
        float f3 = n5 != 0 ? (float)(n5 - n4) / (float)n5 : 0.0f;
        if (f3 == 0.0f) {
            f = 0.0f;
        } else {
            float f4 = (float)(n5 - n) / (float)(n5 - n4);
            float f5 = (float)(n5 - n2) / (float)(n5 - n4);
            float f6 = (float)(n5 - n3) / (float)(n5 - n4);
            f = n == n5 ? f6 - f5 : (n2 == n5 ? 2.0f + f4 - f6 : 4.0f + f5 - f4);
            if ((f /= 6.0f) < 0.0f) {
                f += 1.0f;
            }
        }
        return new float[]{f * 359.0f, f3 * 100.0f, f2 * 100.0f};
    }

    @Nonempty
    public static @NonNull int[] getHSLAsRGBValue(float f, float f2, float f3) {
        float f4 = f / 359.0f;
        float f5 = f2 / 100.0f;
        float f6 = f3 / 100.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (f5 == 0.0f) {
            n2 = n3 = (int)(f6 * 255.0f + 0.5f);
            n = n3;
        } else {
            float f7 = (f4 - (float)Math.floor(f4)) * 6.0f;
            float f8 = f7 - (float)Math.floor(f7);
            float f9 = f6 * (1.0f - f5);
            float f10 = f6 * (1.0f - f5 * f8);
            float f11 = f6 * (1.0f - f5 * (1.0f - f8));
            switch ((int)f7) {
                case 0: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f11 * 255.0f + 0.5f);
                    n3 = (int)(f9 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n = (int)(f10 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f9 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n = (int)(f9 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f11 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n = (int)(f9 * 255.0f + 0.5f);
                    n2 = (int)(f10 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n = (int)(f11 * 255.0f + 0.5f);
                    n2 = (int)(f9 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f9 * 255.0f + 0.5f);
                    n3 = (int)(f10 * 255.0f + 0.5f);
                }
            }
        }
        return new int[]{n, n2, n3};
    }
}

