/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.tools;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.reader.CSSReader;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class MediaQueryTools {
    private static final MediaQueryTools INSTANCE = new MediaQueryTools();

    private MediaQueryTools() {
    }

    public static @Nullable ICommonsList<CSSMediaQuery> parseToMediaQuery(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        String string2 = "@media " + string + " {}";
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string2);
        if (cascadingStyleSheet == null) {
            return null;
        }
        CSSMediaRule cSSMediaRule = (CSSMediaRule)cascadingStyleSheet.getAllMediaRules().get(0);
        return cSSMediaRule.getAllMediaQueries();
    }

    public static boolean canWrapInMediaQuery(@Nullable CascadingStyleSheet cascadingStyleSheet, boolean bl) {
        if (cascadingStyleSheet == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        return !cascadingStyleSheet.hasMediaRules();
    }

    public static @Nullable CascadingStyleSheet getWrappedInMediaQuery(@NonNull CascadingStyleSheet cascadingStyleSheet, @NonNull CSSMediaQuery cSSMediaQuery, boolean bl) {
        return MediaQueryTools.getWrappedInMediaQuery(cascadingStyleSheet, (Iterable<? extends CSSMediaQuery>)new CommonsArrayList((Object)cSSMediaQuery), bl);
    }

    public static @Nullable CascadingStyleSheet getWrappedInMediaQuery(@NonNull CascadingStyleSheet cascadingStyleSheet, @Nonempty @NonNull Iterable<? extends CSSMediaQuery> iterable, boolean bl) {
        ValueEnforcer.notNull((Object)cascadingStyleSheet, (String)"CSS");
        ValueEnforcer.notEmpty(iterable, (String)"MediaQueries");
        if (!MediaQueryTools.canWrapInMediaQuery(cascadingStyleSheet, bl)) {
            return null;
        }
        CascadingStyleSheet cascadingStyleSheet2 = new CascadingStyleSheet();
        for (Object object : cascadingStyleSheet.getAllImportRules()) {
            if (((CSSImportRule)object).hasMediaQueries()) {
                cascadingStyleSheet2.addImportRule((CSSImportRule)object);
                continue;
            }
            ICSSWriteable iCSSWriteable = new CSSImportRule(((CSSImportRule)object).getLocation());
            for (CSSMediaQuery cSSMediaQuery : iterable) {
                iCSSWriteable.addMediaQuery(cSSMediaQuery);
            }
            cascadingStyleSheet2.addImportRule((CSSImportRule)iCSSWriteable);
        }
        for (Object object : cascadingStyleSheet.getAllNamespaceRules()) {
            cascadingStyleSheet2.addNamespaceRule((CSSNamespaceRule)object);
        }
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        for (ICSSWriteable iCSSWriteable : iterable) {
            cSSMediaRule.addMediaQuery((CSSMediaQuery)iCSSWriteable);
        }
        for (ICSSWriteable iCSSWriteable : cascadingStyleSheet.getAllRules()) {
            cSSMediaRule.addRule((ICSSTopLevelRule)iCSSWriteable);
        }
        cascadingStyleSheet2.addRule(cSSMediaRule);
        return cascadingStyleSheet2;
    }
}

